class Color {
	private class ColorValueException extends Exception {
		public ColorValueException(String param) {
			super("RGB vf " + param + " ̒lsł\n\t" + 
				"r = " + r + " : g = " + g + " : b = " + b
			);
		}
	}

	public final int r , g , b;
	Color(int r , int g , int b) throws Exception {
		this.r = r;
		this.g = g;
		this.b = b;

		if (r > 0xFF || r < 0) throw new ColorValueException("r");
		else if (g > 0xFF || g < 0) throw new ColorValueException("g");
		else if (b > 0xFF || b < 0) throw new ColorValueException("b");
		
	}
}

class Test {
	public static void main(String args[]) {
		try { Color color = new Color(0xFF , 0 , -50); }
		catch(Exception err) { System.out.println(err); }
	}
}