import Cocoa

// code 3.2, 3.3
func enclose(stringArray array: Array<String>, headString head: String, tailString tail: String) -> Array<String> {
  var newArray = array
  newArray.insert(head, atIndex: 0)
  newArray.append(tail)
  return newArray
}
var array = enclose(stringArray: ["あ", "い", "う"], headString: "「", tailString: "」")

// code 3.4
func enclose_(var stringArray array: Array<String>, headString head: String, tailString tail: String) -> Array<String> {
  array.insert(head, atIndex: 0)
  array.append(tail)
  return array
}
enclose_(stringArray: ["あ", "い", "う"], headString: "「", tailString: "」")

// code 3.5
func enclose__(var array: Array<String>, head: String, tail: String) -> Array<String> {
  array.insert(head, atIndex: 0)
  array.append(tail)
  return array
}
enclose__(["あ", "い", "う"], "「", "」")

// code 3.6
func enclose___(var #array: Array<String>, #head: String, #tail: String) -> Array<String> {
  array.insert(head, atIndex: 0)
  array.append(tail)
  return array
}
enclose___(array:["あ", "い", "う"], head:"「", tail:"」")

// code 3.7
func enclose____(var stringArray array: Array<String>, headString head: String = "『", tailString tail: String = "』") -> Array<String> {
  array.insert(head, atIndex: 0)
  array.append(tail)
  return array
}
var array0 = ["あ", "い", "う"]
var array1 = enclose____(stringArray: array0)
var array2 = enclose____(stringArray: array0, headString:"{", tailString:"}")

// code 3.8
func joinString(str0: String = "[", str1: String = "]") -> String {
  return str0 + str1
}
joinString()
joinString(str0: "{")
joinString(str1: "}")
joinString(str0: "{", str1: "}")

// code 3.9
func joinString_(by: String = ".", #strings: String...) -> String {
  var resultStr = ""
  for str in strings {
    resultStr += str + by
  }
  return resultStr
}
joinString_(by: ".", strings: "a", "b", "c")

// code 3.11
func parseCommand(command: String) -> (code:Int, comment:String) {
  if command == "A" {
    return (0, "Aコマンドを受信しました")
  } else {
    return (400, "コマンドを解釈できません：" + command)
  }
}
let result0 = parseCommand("A")
result0.code
result0.comment
let result1 = parseCommand("B")
result1.code
result1.comment
let (code, comment) = parseCommand("C")

// code 3.12
func increment(inout value:Int) {
  value = value + 1
}
var b = 10
increment(&b)
b
func enclose_____(inout stringArray array: Array<String>, headString head: String, tailString tail: String) -> Void {
  array.insert(head, atIndex: 0)
  array.append(tail)
}
var array3 = ["あ", "い", "う"]
enclose_____(stringArray: &array3, headString: "[", tailString: "]")
array3

// code 3.13
func calculatedString(count: Int) -> String {
  var paren = ("", "")
  func calc(i2: Int) -> String {
    return paren.0 + String(i2 * i2) + paren.1
  }
  var result = ""
  paren = ("[", "]")
  result += calc(count - 1)
  paren = ("{", "}")
  result += calc(count)
  return result
}
calculatedString(10)