$docroot = $ENV{'DOCROOT'};
$memodir = $docroot."/memo";
$outfile = 'memo_urlindex.html';
$url = "http://localhost/memo/";

opendir(MEMO, $memodir);
@memofiles = grep(/^memo_\d{4}-\d{2}-\d{2}\.html$/, readdir(MEMO));
closedir(MEMO);

print "Content-type: text/html\n\n";
print "<html>\n<head>\n";
print "</head>\n<body bgcolor=\"gray\">\n";
foreach $memofile (sort @memofiles){
  print "<font color=\"yellow\">",$memofile,":</font><br>\n";
  open(FILE, "< $memodir\\$memofile");
  while(<FILE>){
    chomp;
    if(/^<DT>(.+)<DD>(.*)$/i){
      $date = $1;
      if($2 ne ""){
        $name = "";
        $theme = $date;
      }
      print $date, ":<br>\n";
    }elsif(/^<div class=.+<A NAME="([^"]+)">([^<]+)<\/A><\/div>/i){
      $name = "#".$1;$theme = $2;
    }elsif(/^<div class=.+<A NAME="([^"]+)">[^<]*<A HREF="[^"]+">([^<]+)<\/A>[^<]*<\/A><\/div>/i){
      $name = "#".$1;$theme = $2;
    }
    while(/<A HREF="(http:[^"#]+)">([^<]+)<\/A>/gi){
      $anchor{$2} .= $1."\t".$name."\t".$theme."\t".$date."\t".$memofile."@@@";print "<font color=\"white\">", $1."\t".$name."\t".$theme."\t".$date, "</font><br>\n";
    }
  }
  close(FILE);
}
print "</body></html>\n";

open(OUT, "> $memodir\\$outfile");
print OUT <<HERE1;
<HTML>
<HEAD>
  <TITLE>URLCfbNX</TITLE>
  <META HTTP-EQUIV="Content-Type" content="text/html; charset=Shift_JIS">
  <link rel="stylesheet" type="text/css" href="/mystyle.css">
<style type="text/css">
<!--
BODY{background:#FFFFF0}
.item{font-size:12pt;color:blue;font-weight:bold;text-decoration:underline}
//-->
</style>
</HEAD>
<BODY>
<div class="emph">URLCfbNX</div>
HERE1

print OUT "<DL>\n";
foreach $key (sort keys(%anchor)){
  @list = split(/@@@/, $anchor{$key});
  print OUT "<DT>$key<DD>\n";
  foreach $data (@list){
    ($url, $name, $theme, $date, $rnfile) = split(/\t/,$data);
    print OUT "URL: <A HREF=\"$url\">$url</A><BR>^L: <A HREF=\"$rnfile$name\">$theme</A> [$date]<BR>\n";
  }
  print OUT "<BR>\n";
}

print OUT <<HERE2;
</DL><BR>
<HR>
</BODY>
</HTML>
HERE2
close(OUT);
