//---------------------------------------------------------
// Tv		 : ̒ǐՂsvO
// File Name : ObjectTracking.cpp
// Library	 : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <highgui.h>

#define		SEGMENT				150		//	cvSnakeImageŗp鐧_̐
#define		WINDOW_WIDTH		17		//	cvSnakeImageōŏlTߖT̈̕
#define		WINDOW_HEIGHT		17		//	cvSnakeImageōŏlTߖT̈̍
#define		HISTIMAGE_WIDTH		320		//	qXgO摜̕
#define		HISTIMAGE_HEIGHT	200		//	qXgO摜̍
#define		H_DIMENSION		16		//	qXgO̎
#define		H_RANGE_MIN		0
#define		H_RANGE_MAX		180
#define		V_MIN	10		//	x̍ŏl
#define		V_MAX	256		//	x̍ől
#define		S_MIN	30		//	ʓx̍ŏl
#define		S_MAX	256		//	ʓx̍ŏl
#define		HIDDEN_BACKPROJECTION	0	//	obNvWFNV摜\ȂtOl
#define		SHOW_BACKPROJECTION		1	//	obNvWFNV摜\tOl
#define		SELECT_OFF				0	//	ǐ՗̈悪ݒ肳ĂȂƂ̃tOl
#define		SELECT_ON				1	//	ǐ՗̈悪ݒ肳ĂƂ̃tOl
#define		TRACKING_STOP			0	//	gbLO~߂tOl
#define		TRACKING_START			-1	//	gbLOJntOl
#define		TRACKING_NOW			1	//	gbLOtOl
#define		HIDDEN_HISTOGRAM		0	//	qXgO\ȂtOl
#define		SHOW_HISTOGRAM			1	//	qXgO\tOl
#define		ITERATION_SNAKE			10	//	cvSnakeImage̔

IplImage	*resultImage = NULL;			//	ʕ\pIplImage
IplImage	*hsvImage = NULL;			//	HSV\FnpIplImage
IplImage	*hueImage = NULL;			//	HSV\FnH`lpIplImage
IplImage	*maskImage = NULL;			//	}XN摜pIplImage
IplImage	*backprojectImage = NULL;	//	obNvWFNV摜pIplImage
IplImage	*histImage = NULL;			//	qXgO`pIplImage
IplImage	*grayImage = NULL;			//	O[XP[摜pIplImage

CvHistogram	*hist = NULL;				//	qXgOp\

//	[hIptO
int	backprojectMode = HIDDEN_BACKPROJECTION;
int	selectObject = SELECT_OFF;
int	trackObject = TRACKING_STOP;
int showHist = SHOW_HISTOGRAM;

//	CamShiftgbLOpϐ
CvPoint			origin;
CvRect			selection;
CvRect			trackWindow;
CvBox2D			trackRegion;
CvConnectedComp	trackComp;

//	qXgOpϐ
int		hdims = H_DIMENSION;		//	qXgO̎
float	hRangesArray[] = {H_RANGE_MIN, H_RANGE_MAX};	//qXgÕW
float	*hRanges = hRangesArray;
int		vmin = V_MIN;
int		vmax = V_MAX;

//
//	}EXhbOɂďǐ՗̈w肷
//
//	:
//		event	: }EX{^̏
//		x		: }EX݃|CgĂxW
//		y		: }EX݃|CgĂyW
//		flags	: {vOł͖gp
//		param	: {vOł͖gp
//
void on_mouse( int event, int x, int y, int flags, void* param ){
	//	摜擾ĂȂ΁AsȂ
	if( resultImage == NULL ){
        return;
	}
	//	_̈ʒuɉy̒l𔽓]i摜̔]ł͂Ȃj
	if( resultImage->origin == 1 ){
        y = resultImage->height - y;
	}
	//	}EX̍{^ĂΈȉ̏s
    if( selectObject == SELECT_ON ){
        selection.x = MIN( x, origin.x );
        selection.y = MIN( y, origin.y );
        selection.width = selection.x + CV_IABS( x - origin.x );
        selection.height = selection.y + CV_IABS( y - origin.y );
        
        selection.x = MAX( selection.x, 0 );
        selection.y = MAX( selection.y, 0 );
        selection.width = MIN( selection.width, resultImage->width );
        selection.height = MIN( selection.height, resultImage->height );
        selection.width = selection.width - selection.x;
        selection.height = selection.height - selection.y;
    }
	//	}EX̍{^̏Ԃɂď𕪊
    switch( event ){
		case CV_EVENT_LBUTTONDOWN:
			//	}EX̍{^ꂽ̂ł΁A
			//	_ёIꂽ̈ݒ
			origin = cvPoint( x, y );
			selection = cvRect( x, y, 0, 0 );
			selectObject = SELECT_ON;
			break;
		case CV_EVENT_LBUTTONUP:
			//	}EX̍{^ꂽƂAwidthheightǂł΁A
			//	trackObjecttOTRACKING_STARTɂ
			selectObject = SELECT_OFF;
			if( selection.width > 0 && selection.height > 0 ){
				trackObject = TRACKING_START;
			}
			break;
    }
}

//
//	͂ꂽ1̐FlRGBɕϊ
//
//	:
//		hue		: HSV\FnɂFlH
//	߂lF
//		CvScalar: RGB̐FBGȐŊi[ꂽRei
//
CvScalar hsv2rgb( float hue ){
	IplImage *rgbValue, *hsvValue;
	rgbValue = cvCreateImage( cvSize(1,1), IPL_DEPTH_8U, 3 );
	hsvValue = cvCreateImage( cvSize(1,1), IPL_DEPTH_8U, 3 );

	hsvValue->imageData[0] = hue;	//	FlH
	hsvValue->imageData[1] = 255;	//	ʓxlS
	hsvValue->imageData[2] = 255;	//	xlV
	
	//	HSV\FnRGB\Fnɕϊ
	cvCvtColor( hsvValue, rgbValue, CV_HSV2BGR );

	return cvScalar(	(unsigned char)rgbValue->imageData[0], 
						(unsigned char)rgbValue->imageData[1], 
						(unsigned char)rgbValue->imageData[2], 
						0 );

	//	
	cvReleaseImage( &rgbValue );
	cvReleaseImage( &hsvValue );
}


//
//	}EXIꂽǐ՗̈ɂHSVHlŃqXgO쐬AqXgO̕`܂łs
//
//	:
//		hist		: mainŐ錾ꂽqXgOp\
//		hsvImage	: ͉摜HSV\FnɕϊꂽIplImage
//		maskImage	: }XN摜pIplImage
//		selection	: }EXőIꂽ`̈
//
void CalculateHist( CvHistogram	*hist, IplImage *hsvImage, IplImage *maskImage, CvRect selection ){
	int		i;
	int		binW;	//	qXgO̊eŕA摜ł̕
	int		val;	//	qXgO̕px
	float	maxVal;	//	qXgO̍őpx


	//	hsv摜̊efl͈͓̔ɓĂ邩`FbNA
	//	}XN摜maskImage쐬
	cvInRangeS( hsvImage, 
				cvScalar( H_RANGE_MIN, S_MIN, MIN(V_MIN,V_MAX), 0 ),
				cvScalar( H_RANGE_MAX, S_MAX, MAX(V_MIN,V_MAX), 0 ), 
				maskImage );
	//	hsvImagêAƂɕKvH`lhueImageƂĕ
	cvSplit( hsvImage, hueImage, 0, 0, 0 );
	//	trackObjectTRACKING_STARTԂȂAȉ̏s
	if( trackObject == TRACKING_START ){
		//	ǐ՗̈̃qXgOvZhistImageւ̕`
		maxVal = 0.0;

		cvSetImageROI( hueImage, selection );
        cvSetImageROI( maskImage, selection );
        //	qXgOvZAől߂
		cvCalcHist( &hueImage, hist, 0, maskImage );
		cvGetMinMaxHistValue( hist, 0, &maxVal, 0, 0 );
        //	qXgȌcipxj0-255̃_Ci~bNWɐK
		if( maxVal == 0.0 ){
			cvConvertScale( hist->bins, hist->bins, 0.0, 0 );
		} else{
			cvConvertScale( hist->bins, hist->bins, 255.0 / maxVal, 0 );
		}
		//	hue,mask摜ɐݒ肳ꂽROIZbg
		cvResetImageROI( hueImage );
        cvResetImageROI( maskImage );

        trackWindow = selection;
        //	trackObjectTRACKING_NOWɂ
		trackObject = TRACKING_NOW;

		//	qXgO摜[NA
        cvSetZero( histImage );
		//	er̕߂
        binW = histImage->width / hdims;
		//	qXgO`悷
        for( i = 0; i < hdims; i++ ){
			val = cvRound( cvGetReal1D(hist->bins,i) * histImage->height / 255 );
            CvScalar color = hsv2rgb( i * 180.0 / hdims );
            cvRectangle(	histImage, 
							cvPoint( i * binW, histImage->height ), 
							cvPoint( (i+1) * binW, histImage->height - val ),
							color,
							-1, 
							8, 
							0	);
		}
	}
}


int main( void ){
	char		windowNameHistogram[] = "Histogram";			//	qXgO\EChE
	char		windowNameObjectTracking[] = "ObjectTracking";	//	̒ǐՌʂ\EChE

	IplImage	*frameImage;	//	Lv`摜pIplImage
    CvCapture	*capture;		//	L[͌ʂi[ϐ
    
    int		i;
	int		j;
	int		key;	//	L[͌ʂi[ϐ
	//	Snakep̃p[^
	float alpha = 1.0;		//	AGlM[̏d݃p[^
	float beta = 0.5;		//	ȗ̏d݃p[^
	float gamma = 1.5;		//	摜GlM[̏d݃p[^
	CvPoint pt[SEGMENT];	//	_̍W
	CvSize window;			//	ŏlTߖTTCY
	window.width = WINDOW_WIDTH;	
	window.height = WINDOW_HEIGHT;
	CvTermCriteria crit;
	crit.type = CV_TERMCRIT_ITER;		//	I̐ݒ
	crit.max_iter = ITERATION_SNAKE;	//	֐̍ő唽

	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ){
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}

    printf( "Hot keys: \n"
        "\tq - quit the program\n"
        "\tc - stop the tracking\n"
        "\tb - switch to/from backprojection view\n"
        "\th - show/hide object histogram\n"
        "To initialize tracking, select the object with mouse\n" );

	//	EChE𐶐
	cvNamedWindow( windowNameHistogram, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameObjectTracking, CV_WINDOW_AUTOSIZE );
	
	//	gbNo[𐶐
	cvSetMouseCallback( windowNameObjectTracking, on_mouse, 0 );
	cvCreateTrackbar( "Vmin", windowNameObjectTracking, &vmin, 256, 0 );
	cvCreateTrackbar( "Vmax", windowNameObjectTracking, &vmax, 256, 0 );
	cvCreateTrackbar( "Smin", windowNameObjectTracking, &vmin, 256, 0 );

    while( 1 ){
		//	Lv`摜̎擾Ɏs珈𒆒f
        frameImage = cvQueryFrame( capture );
		if( frameImage == NULL ){
            break;
		}
		//	Lv`ɐ珈p
        if( resultImage == NULL ){
            //	e摜̊m
            resultImage = cvCreateImage( cvGetSize(frameImage), IPL_DEPTH_8U, 3 );
			resultImage->origin = frameImage->origin;
            hsvImage = cvCreateImage( cvGetSize(frameImage), IPL_DEPTH_8U, 3 );
            hueImage = cvCreateImage( cvGetSize(frameImage), IPL_DEPTH_8U, 1 );
            maskImage = cvCreateImage( cvGetSize(frameImage), IPL_DEPTH_8U, 1 );
            backprojectImage = cvCreateImage( cvGetSize(frameImage), IPL_DEPTH_8U, 1 );
			grayImage = cvCreateImage(cvGetSize(frameImage), IPL_DEPTH_8U, 1);
			//	qXgO\̂̎gp錾
            hist = cvCreateHist( 1, &hdims, CV_HIST_ARRAY, &hRanges, 1 );
			//	qXgOp̉摜mۂA[NA
            histImage = cvCreateImage( cvSize(HISTIMAGE_WIDTH, HISTIMAGE_HEIGHT), IPL_DEPTH_8U, 3 );
            cvSetZero( histImage );
		}
		//	Lv`ꂽ摜resultImageɃRs[AHSV\FnɕϊhsvImageɊi[
        cvCopy( frameImage, resultImage, NULL );
        cvCvtColor( resultImage, hsvImage, CV_BGR2HSV );

		//	trackObjecttOTRACKING_STOPȊOȂAȉ̏s
        if( trackObject != TRACKING_STOP ){

			//ǐ՗̈̃qXgOvZƕ`
			CalculateHist(	hist, hsvImage, maskImage, selection );

			//	obNvWFNVvZ
            cvCalcBackProject( &hueImage, backprojectImage, hist );
            //	backProjection̂A}XN1łƂꂽ̂ݎc
			cvAnd( backprojectImage, maskImage, backprojectImage, 0 );

			//	CamShift@ɂ̈ǐՂs
			cvCamShift( backprojectImage, 
						trackWindow, 
						cvTermCriteria( CV_TERMCRIT_EPS | CV_TERMCRIT_ITER, 10, 1 ), 
						&trackComp, 
						&trackRegion );
			
			trackWindow = trackComp.rect;

			//	SnakeImagep̃O[XP[摜쐬
			cvCvtColor( resultImage, grayImage, CV_BGR2GRAY );

			if( backprojectMode == SHOW_BACKPROJECTION ){
                cvCvtColor( backprojectImage, resultImage, CV_GRAY2BGR );
			}
			if( resultImage->origin == 1 ){
                trackRegion.angle = -trackRegion.angle;
			}

			//	CamShiftł̗̈ǐՌʂSnakȅʒuɐݒ肷
			for( i=0; i<SEGMENT; i++ ){
				pt[i].x = cvRound(	trackRegion.size.width 
									* cos(i * 6.28 / SEGMENT + trackRegion.angle) 
									/ 2.0 + trackRegion.center.x );
				pt[i].y = cvRound(	trackRegion.size.height 
									* sin(i * 6.28 / SEGMENT + trackRegion.angle) 
									/ 2.0 + trackRegion.center.y );
			}
			//	Snakeɂ֊sos
			for( i=0; i<ITERATION_SNAKE; i++ ){
				cvSnakeImage(	grayImage, 
								pt, 
								SEGMENT, 
								&alpha, 
								&beta, 
								&gamma, 
								CV_VALUE, 
								window, 
								crit, 
								1);
				//	e֊s_̊ԂɐЂė֊s`悷
				for( j=0; j<SEGMENT; j++ ){
					if( j < SEGMENT-1 ){
						cvLine( resultImage, pt[j], pt[j+1], 
						  cvScalar(0,0,255,0), 2, 8, 0 );
					}
					else{ 
						cvLine( resultImage, pt[j], pt[0], 
						  cvScalar(0,0,255,0),  2, 8, 0 );
					}
				}
			}
        }
		//	}EXőI𒆂̏ǐ՗̈̐F𔽓]
        if( selectObject == SELECT_ON && selection.width > 0 && selection.height > 0 ){
            cvSetImageROI( resultImage, selection );
            cvXorS( resultImage, cvScalarAll(255), resultImage, 0 );
            cvResetImageROI( resultImage );
        }
		//	backprojectImage̍W_̏ꍇA㉺𔽓]
		if( backprojectImage->origin == 0 ){
			cvFlip( backprojectImage, backprojectImage, 0 );
		}
 
		//	摜\
		cvShowImage( windowNameObjectTracking, resultImage );
        cvShowImage( windowNameHistogram, histImage );
		
		//	L[͂҂AꂽL[ɂď𕪊򂳂
        key = cvWaitKey(10);
        if( (char) key == 'q' )
			//	while[vEoivOIj
            break;
        switch( (char) key ){
        case 'b':
			//	\摜obNvWFNV摜ɐ؂ւ
			if( backprojectMode == HIDDEN_BACKPROJECTION ){
				backprojectMode = SHOW_BACKPROJECTION;
			}
			else{
				backprojectMode = HIDDEN_BACKPROJECTION;
			}
			break;
        case 'c':
			//	gbLO𒆎~
            trackObject = TRACKING_STOP;
            cvSetZero( histImage );
            break;
        case 'h':
			//	qXgO̕\/\؂ւ
			if( showHist == HIDDEN_HISTOGRAM ){
				showHist = SHOW_HISTOGRAM;
			}
			else{
				showHist = HIDDEN_HISTOGRAM;
			}
			if( showHist == NULL ){
                cvDestroyWindow( windowNameHistogram );
			}
			else{
                cvNamedWindow( windowNameHistogram, CV_WINDOW_AUTOSIZE );
			}
			break;
        default:
            ;
        }
    }
	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &resultImage );
	cvReleaseImage( &hsvImage );
	cvReleaseImage( &hueImage);
	cvReleaseImage( &maskImage );
	cvReleaseImage( &backprojectImage );
	cvReleaseImage( &histImage );
	cvReleaseImage( &grayImage );
	//	EChEj
	cvDestroyWindow( windowNameObjectTracking );

	return 0;
}