//---------------------------------------------------------
// Tv      : WP̔
// File Name : rockpaperscissors.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include "rockpaperscissors.h"

char windowNameCapture[] = "Capture"; 		//	Lv`摜\EBhE̖O
char windowNameSkin[] = "Skin";				//	Fo摜\EBhE̖O
char windowNameConvexHull[] = "ConvexHull";	//	ConnvexHull摜\EBhE̖O

//
//@EBhE쐬
//
void createWindows() {
	cvNamedWindow( windowNameCapture );
	cvNamedWindow( windowNameSkin );
	cvNamedWindow( windowNameConvexHull );
}

//
//	F𒊏o
//
//	:
//		frameImage : Lv`摜pIplImage
//		hsvImage   : HSV摜pIplImage
//		skinImage  : Fo摜pIplImage
//
void extractSkinColor( IplImage *frameImage, IplImage *hsvImage, IplImage *skinImage ) {
	CvScalar color;		//	HSV\Fnŕ\F
	unsigned char h;	//	H
	unsigned char s;	//	S
	unsigned char v;	//	V
	
	//	BGRHSVɕϊ
	cvCvtColor( frameImage, hsvImage, CV_BGR2HSV );

	//Fo
	for( int x = 0; x < skinImage->width; x++ ) {
		for( int y = 0 ; y < skinImage->height; y++ ) {

			color = cvGet2D( hsvImage, y, x );
			h = color.val[0];
			s = color.val[1];
			v = color.val[2];

			if( h <= HMAX && h >= HMIN &&
				s <= SMAX && s >= SMIN &&
					v <= VMAX && v >= VMIN ) {
				//	F̏ꍇ
				cvSetReal2D( skinImage, y, x, 255 );
			} else {
				cvSetReal2D( skinImage, y, x, 0 );
			}
		}
	}
}

//
//	̈Ԃ
//
//	:
//		skinImage : Fo摜pIplImage
//		temp      : ꎞۑpIplImage
//
void interpolate( IplImage *skinImage, IplImage *temp ) {
	//cITERATIONSs
	cvDilate( skinImage, temp, NULL, ITERATIONS );

	//kITERATIONSs
	cvErode( temp, skinImage, NULL, ITERATIONS );
}

//
//	ő̈(̈)̒os
//
//	:
//		skinImage       : Fo摜pIplImage
//		label           : xO
//		convexHullImage : ConvexHull摜pIplImage
//
//	߂l:
//		̖̈ʐ
//
int pickupMaxArea(IplImage *skinImage, IplImage *label, IplImage *convexHullImage ) {

	int handarea = 0;	//	̖̈ʐ

	for(int x = 0; x < skinImage->width; x++ ) {
		for( int y=0; y < skinImage->height; y++ ) {
			if( cvGetReal2D( label, y, x ) == 1 ) {
				//	ő̈悾ꍇ
				handarea++;
				cvSet2D( convexHullImage, y, x, CV_RGB( 255, 255, 255 ) );
			} else {
				cvSetReal2D( skinImage, y, x, 0 );
				cvSet2D( convexHullImage, y, x, CV_RGB( 0, 0, 0 ) );
			}
		}
	}
	return handarea;
}

//
//	ConvexHull𐶐
//
//	:
//		skinImage   : Fo摜pIplImage
//		handarea    : ̖̈ʐ(_̐)
//		handpoint   : ̈̓_̍Wzւ̃|C^
//		hull        : ConvexHull̒_handpointɂindexԍւ̃|C^
//		pointMatrix : ̈psւ̃|C^
//		hullMatrix  : ConvexHullpsւ̃|C^
//
void createConvexHull(IplImage *skinImage, int handarea, CvPoint **handpoint, int **hull,
					  CvMat *pointMatrix, CvMat *hullMatrix ) {
	int i=0;

	//	ConvexHullvZ邽߂ɕKvȍs𐶐
	*handpoint=( CvPoint * )malloc( sizeof( CvPoint ) * handarea );
	*hull = ( int * )malloc( sizeof( int ) * handarea );
	*pointMatrix = cvMat( 1, handarea, CV_32SC2, *handpoint );
	*hullMatrix = cvMat( 1, handarea, CV_32SC1, *hull );

	for( int x = 0; x < skinImage->width; x++ ) {
		for(  int y = 0; y < skinImage->height; y++ ) {
			if( cvGetReal2D( skinImage, y, x ) == 255 ) {
				( *handpoint )[i].x = x;
				( *handpoint )[i].y = y;
				i++;
			}
		}
	}

	//	ConvexHull𐶐
	cvConvexHull2( pointMatrix, hullMatrix, CV_CLOCKWISE, 0 );
}

//
//	ConvexHull`悷
//
//	:
//		convexHullImage : ConvexHull摜pIplImage
//		handpoint       : ̈̓_̍Wz
//		hull            : ConvexHull̒_handpointɂindexԍ
//		hullcount       : ConvexHull̒_̐
//
void drawConvexHull(IplImage *convexHullImage, CvPoint *handpoint, int *hull, int hullcount ) {
	CvPoint pt0 = handpoint[hull[hullcount-1]];
	for( int i = 0; i < hullcount; i++ ) {
		CvPoint pt = handpoint[hull[i]];
		cvLine( convexHullImage, pt0, pt, CV_RGB( 0, 255, 0 ) );
		pt0 = pt;
	}
}

//
//	ConvexHull̖ʐς߂
//
//	:
//		convexHullImage : ConvexHull摜pIplImage
//		handpoint       : ̈̓_̍Wz
//		hull            : ConvexHull̒_handpointɂindexԍ
//		hullcount       : ConvexHull̒_̐@@
//
//	߂l:
//		ConvexHull̖ʐ
//
int calcConvexHullArea( IplImage *convexHullImage, CvPoint *handpoint, int *hull, int hullcount ) {

	//	ConvexHull̒_Ȃs𐶐
	CvPoint *hullpoint = ( CvPoint * )malloc( sizeof( CvPoint ) * hullcount );
	CvMat hMatrix = cvMat( 1, hullcount, CV_32SC2, hullpoint );
	for( int i = 0; i < hullcount; i++ ) {
		hullpoint[i]=handpoint[hull[i]];
	}

	//	ConvexHull̓_̐𐔂
	int hullarea = 0;
	for( int x = 0; x < convexHullImage->width; x++ ) {
		for( int y = 0;y < convexHullImage->height; y++ ) {
			if( cvPointPolygonTest( &hMatrix, cvPoint2D32f( x, y ), 0 ) > 0) {
				hullarea++;
			}
		}
	}

	free( hullpoint );
	return hullarea;
}

//
//	WP̔s
//
//	:
//		handarea : ̖̈ʐ
//		hullarea : ConvexHull̖ʐ
//
void decide( int handarea, int hullarea ) {
	double ratio;	//	ConvexHull̖ʐςɑ΂̖̈ʐς̊
	
	ratio=handarea / ( double )hullarea;	
	printf( "Ratio = %lf\n", ratio );

	if( ratio >= ROCKMIN && ratio <= ROCKMAX ) {
		printf( "O[\n" );
	} else if( ratio >= SCISSORMIN && ratio <= SCISSORMAX ) {
		printf( "`L\n" );
	} else if( ratio >= PAPERMIN && ratio <= PAPERMAX ) {
		printf( "p[\n" );
	}
}

int main( int argc, char **argv ) {
	int key;					//	L[͗p̕ϐ
	CvCapture *capture = NULL;	//	JLv`p̍\

	//	J
	if( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ) {
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}
	
	IplImage *frameImage = cvQueryFrame( capture );	//	Lv`摜pIplImage

	//	摜𐶐
	IplImage *hsvImage = cvCreateImage( cvGetSize( frameImage ),IPL_DEPTH_8U,3);		//	HSV摜pIplImage
	IplImage *convexHullImage = cvCreateImage( cvGetSize( frameImage ),IPL_DEPTH_8U,3 );//	ConvexHull摜pIplImage
	IplImage *skinImage = cvCreateImage( cvGetSize( frameImage ),IPL_DEPTH_8U,1);		//	Fo摜pIplImage
	IplImage *temp = cvCreateImage( cvGetSize( frameImage ),IPL_DEPTH_8U,1);			//	ꎞۑpIplImage
	IplImage *label = cvCreateImage( cvGetSize( frameImage ),IPL_DEPTH_16S,1);			//	xʕۑpIplImage

	//	EBhE𐶐
	createWindows();

	while( 1 ){

		frameImage = cvQueryFrame( capture );

		//	F𒊏o
		extractSkinColor( frameImage, hsvImage, skinImage );

		//	̈Ԃ
		interpolate( skinImage, temp );
		
		//	xOs
		Label *labeling = createLabeling();
		exec( labeling, skinImage, label, true, IGNORE_SIZE );

		if( getNumOfResultRegions( labeling ) > 0 ) {
			//	IGNORE_SIZE傫ȗ̈悪ꍇ

			int handarea;		//	̖̈ʐ
			int hullarea;		//	ConvexHull̖ʐ
			int hullcount;		//	ConvexHull̒_̐
			CvPoint *handpoint;	//	̈̓_̍Wz
			int *hull;			//	ConvexHull̒_handpointɂindexԍ
			CvMat pointMatrix;	//	̈ps
			CvMat hullMatrix;	//	ConvexHullps

			//	ő̈(̈)̒os
			handarea = pickupMaxArea( skinImage, label, convexHullImage );

			//	ConvexHull𐶐
			createConvexHull( skinImage, handarea, &handpoint, &hull, &pointMatrix, &hullMatrix );
			
			hullcount = hullMatrix.cols;

			//	ConvexHull`悷
			drawConvexHull( convexHullImage, handpoint, hull, hullcount );

			//	ConvexHull̖ʐς߂
			hullarea = calcConvexHullArea( convexHullImage, handpoint,hull, hullcount );

			//	WP̔s
			decide( handarea, hullarea );

			//	
			free( handpoint );
			free( hull );
		} else {
			//	摜
			cvSetZero( convexHullImage );
		}

		releaseLabeling( labeling );

		if ( skinImage->origin == 0 ) {
			//@オ_̏ꍇ
			cvFlip( skinImage, skinImage, 0 );
		}
		if ( convexHullImage->origin == 0 ) {
			//@オ_̏ꍇ
			cvFlip( convexHullImage, convexHullImage, 0 );
		}

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		cvShowImage( windowNameSkin, skinImage );
		cvShowImage( windowNameConvexHull, convexHullImage );

		//	L[͔
		key = cvWaitKey( 1 );
		if( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		}
	}
	
	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &hsvImage );
	cvReleaseImage( &skinImage );
	cvReleaseImage( &temp );
	cvReleaseImage( &label );
	cvReleaseImage( &convexHullImage );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameSkin );
	cvDestroyWindow( windowNameConvexHull );

	return 0;
}