//---------------------------------------------------------------------
//Tv		: 摜̖cAks
//File Name	: morphology.cpp
//Library	: OpenCV for MS-Windows 1.0
//---------------------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define THRESHOLD	128			//	2l̍ۂ臒l
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

#define DILATIONS	3	//	c
#define EROSIONS	3	//	k

int main( int argc, char* argv[] ) {	
	char windowNameBinary[]="Binary";	//	2l摜\EBhE̖O
	char windowNameDilate[]="Dilate";	//	c摜\EBhE̖O
	char windowNameErode[]="Erode";		//	k摜\EBhE̖O

	//	摜ǂݍ
	IplImage  *sourceImage = cvLoadImage( "image/source.bmp",CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
	IplImage  *grayImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );		//	O[XP[摜pIplImage
	IplImage  *binaryImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );		//	2l摜pIplImage
	IplImage  *dilationImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );	//	c摜pIplImage
	IplImage  *erosionImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 ); 	//	k摜pIplImage
	
	//	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	O[XP[2lɕϊ
	cvThreshold( grayImage, binaryImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	DILATIONS cs@
	cvDilate( binaryImage , dilationImage, NULL, DILATIONS );
	
	//	EROSIONS@ks
	cvErode( dilationImage, erosionImage, NULL, EROSIONS );

	//	EBhE𐶐
	cvNamedWindow( windowNameBinary,CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDilate,CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameErode,CV_WINDOW_AUTOSIZE );
	
	//	摜\
   	cvShowImage( windowNameBinary, binaryImage );
	cvShowImage( windowNameDilate, dilationImage );
	cvShowImage( windowNameErode,erosionImage );
    
	//	L[͂҂
    cvWaitKey( 0 );

	//	摜ۑ
    cvSaveImage( "image/erosion.bmp",erosionImage );
	cvSaveImage( "image/dilation.bmp",dilationImage );
    
	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &binaryImage );
	cvReleaseImage( &dilationImage );
	cvReleaseImage( &erosionImage );
	//	EBhEj
	cvDestroyWindow( windowNameBinary );
	cvDestroyWindow( windowNameDilate );
	cvDestroyWindow( windowNameErode );

	return 0;
}
