//---------------------------------------------------------
// Tv      : ev[g}b`O
// File Name : template.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define THRESHOLD	50			//	2l̍ۂ臒l
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

#define LINE_THICKNESS	1	//	̑
#define	LINE_TYPE	8		//	̎
#define SHIFT	0			//	W̏_ȉ̌\rbg

int main( int argc, char **argv ) {

	char windowNameTemplate[] = "Template";			//	ev[g摜\EBhE̖O
	char windowNameDestination[] = "Destination";	//	}b`Oʂ\EBhE̖O

	CvPoint minLocation;	//	xŏɂȂꏊ
	
	//	摜ǂݍ
    IplImage *sourceImage = cvLoadImage( "image/source.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );
	IplImage *templateImage = cvLoadImage( "image/template.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL || templateImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
    IplImage *sourceGrayImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );		//	摜O[XP[摜pIplImage
	IplImage *templateGrayImage = cvCreateImage( cvGetSize(templateImage), IPL_DEPTH_8U, 1 );	//	ev[g摜O[XP[摜pIplImage
    IplImage *sourceBinaryImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );		//	摜2l摜pIplImage
	IplImage *templateBinaryImage = cvCreateImage( cvGetSize(templateImage), IPL_DEPTH_8U, 1 );	//	ev[g摜2l摜pIplImage
	IplImage *differenceMapImage = cvCreateImage( cvSize( sourceImage->width - templateImage->width + 1, sourceImage->height - templateImage->height + 1 ), IPL_DEPTH_32F, 1 );	//	x}bv摜pIplImage

    //	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, sourceGrayImage, CV_BGR2GRAY );
	cvCvtColor( templateImage, templateGrayImage, CV_BGR2GRAY );
	
	//	O[XP[2lɕϊ
	cvThreshold( sourceGrayImage, sourceBinaryImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );
	cvThreshold( templateGrayImage, templateBinaryImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	ev[g}b`Os
	cvMatchTemplate( sourceBinaryImage, templateBinaryImage, differenceMapImage, CV_TM_SQDIFF );

	//	ev[g摜̂ǂ̕ɂ̂Ƃ𓾂
	cvMinMaxLoc( differenceMapImage, NULL, NULL, &minLocation, NULL, NULL );

	//	vꏊ摜Ɏlpŕ`
	cvRectangle(
		sourceImage,
		minLocation,
		cvPoint( minLocation.x + templateImage->width, minLocation.y + templateImage->height ),
		CV_RGB( 255, 0, 0 ),
		LINE_THICKNESS,
		LINE_TYPE,
		SHIFT
	);

	//	EBhE𐶐
	cvNamedWindow( windowNameTemplate, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDestination, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameTemplate, templateImage );
	cvShowImage( windowNameDestination , sourceImage );

	//	L[͂҂
    cvWaitKey(0);
    
	//	摜ۑ
	cvSaveImage( "image/destination.bmp", sourceImage );
	
	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &templateImage );
	cvReleaseImage( &sourceGrayImage );
	cvReleaseImage( &templateGrayImage );
	cvReleaseImage( &sourceBinaryImage );
	cvReleaseImage( &templateBinaryImage );
	cvReleaseImage( &differenceMapImage );
	//	EBhEj
	cvDestroyWindow(windowNameTemplate);
	cvDestroyWindow(windowNameDestination);
	
	return 0;
}
