//---------------------------------------------------------
// Tv      : ntϊ
// File Name : houghlines.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <math.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

//	cvCannyp萔
#define	CANNY_THRESHOLD1	50	//	1Ԗڂ臒l (t@XQ)
#define CANNY_THRESHOLD2	80	//	2Ԗڂ臒l (t@XQ)
#define	APERTURE_SIZE		3	//	SobelIy[^̃TCY (t@XQ)

//	cvHoughLines2p萔
#define RHO					1						//	p[^Ԃɂώ̕\(sNZP)
#define THETA				( CV_PI / 180 )			//	p[^ԂɂƎ̕\(WAP)
#define HOUGHLINE_METHOD	CV_HOUGH_PROBABILISTIC	//	ntϊ̎@ (t@XQ)
#define HOUGHLINE_THRESHOLD	50						//	𒊏oۂ̃p[^Ԃł̓[臒l
#define HOUGHLINE_PARAM1	50						//	@ɉ1Ԗڂ̃p[^ (t@XQ)
#define HOUGHLINE_PARAM2	10						//	@ɉ2Ԗڂ̃p[^ (t@XQ)

//	cvLinep萔
#define LINE_THICKNESS	2	//	̑
#define LINE_TYPE		8	//	̎
#define SHIFT			0	//	W̏_ȉ̌\rbg

int main( int argc, char **argv ) {
	char windowNameSource[] = "Source";	//	摜\EBhE̖O
	char windowNameHough[] = "Hough";	//	ntϊɂ蒊oꂽ\EBhE̖O

	CvMemStorage *storage = cvCreateMemStorage( 0 );//	ntϊɕKvȃ̈
	CvSeq *lines = NULL;							//	ntϊɂ蒊oꂽ

	//	摜ǂݍ
    IplImage *sourceImage = cvLoadImage( "image/source.jpg", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}
    
	//	摜𐶐
    IplImage *grayImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );	//	O[XP[摜pIplImage
	IplImage *edgeImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );	//	GbWo摜pIplImage
    IplImage *houghImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 3 );	//	ntϊpIplImage
	
	//	BGRO[XP[ɕϊ
    cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	GbWos
    cvCanny( grayImage, edgeImage, CANNY_THRESHOLD1, CANNY_THRESHOLD2, APERTURE_SIZE );

	//	O[XP[BGRɕϊ
    cvCvtColor( edgeImage, houghImage, CV_GRAY2BGR );

	//	ntϊɂ蒼̒os
    lines = cvHoughLines2( edgeImage, storage, HOUGHLINE_METHOD, RHO, THETA, HOUGHLINE_THRESHOLD, HOUGHLINE_PARAM1, HOUGHLINE_PARAM2 );

	//	oꂽ`
    for ( int i = 0; i < lines->total; i++ ) {
        CvPoint *line = ( CvPoint* )cvGetSeqElem( lines, i );
        cvLine( houghImage, line[0], line[1], CV_RGB( 255, 0, 0 ), LINE_THICKNESS, LINE_TYPE, SHIFT );
    }

	//	EBhE𐶐
    cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameHough, CV_WINDOW_AUTOSIZE );

	//	摜\
    cvShowImage( windowNameSource, sourceImage );
    cvShowImage( windowNameHough, houghImage );

	//	L[͂҂
    cvWaitKey( 0 );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &edgeImage );
	cvReleaseImage( &houghImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameHough );

    return 0;
}

