//---------------------------------------------------------
// Tv      : GbWo
// File Name : edge.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define SOBEL_X_APERTURE_SIZE	3	//	SobelIy[^̃TCY (t@XQ)
#define SOBEL_Y_APERTURE_SIZE	3	//	SobelIy[^̃TCY (t@XQ)
#define LAPLACIAN_APERTURE_SIZE	3	//	LaplacianIy[^̃TCY (t@XQ)

//	cvConvertScaleAbsp萔
#define SCALE	1	//	ScaleAbsW
#define	SHIFT	0	//	XP[O͔z̗vfɉl

int main( int argc, char **argv ) {

	char windowNameSource[] = "Source";		//	摜\EBhE̖O
	char windowNameSobelX[] = "SobelX";		//	XSobelIy[^ŏ摜\EBhE̖O
	char windowNameSobleY[] = "SobelY";		//	YSobelIy[^ŏ摜\EBhE̖O
	char windowNameLaplace[] = "Laplace";	//	LaplacianIy[^ŏ摜\EBhE̖O

	//	摜ǂݍ
    IplImage *sourceImage = cvLoadImage( "image/source.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}
	
	//	摜𐶐
	IplImage *grayImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );		//	O[XP[摜pIplImage
	IplImage *sobelXImage16 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_16S, 1 );	//	XSobelIy[^ŏ摜(16bit)pIplImage
	IplImage *sobelYImage16 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_16S, 1 );	//	YSobelIy[^ŏ摜(16bit)pIplImage
	IplImage *laplaceImage16 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_16S, 1 );	//	LaplaceIy[^ŏ摜(16bit)pIplImage
	IplImage *sobelXImage8 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );	//	XSobelIy[^ŏ摜(8bit)pIplImage
	IplImage *sobelYImage8 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );	//	YSobelIy[^ŏ摜(8bit)pIplImage
	IplImage *laplaceImage8 = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );	//	LaplacianIy[^ŏ摜(8bit)pIplImage
	
	//	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	XSobelIy[^
	cvSobel( grayImage, sobelXImage16, 1, 0, SOBEL_X_APERTURE_SIZE );

	//	YSobelIy[^
	cvSobel( grayImage, sobelYImage16, 0, 1, SOBEL_Y_APERTURE_SIZE );
	
	//	LaplaceIy[^
	cvLaplace( grayImage, laplaceImage16, LAPLACIAN_APERTURE_SIZE );
	
	//	16rbg̕f[^8rbg̕Ȃf[^ɕϊ
	cvConvertScaleAbs( sobelXImage16, sobelXImage8, SCALE, SHIFT );
	cvConvertScaleAbs( sobelYImage16, sobelYImage8, SCALE, SHIFT );
	cvConvertScaleAbs( laplaceImage16, laplaceImage8, SCALE, SHIFT );
	
	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameSobelX, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameSobleY, CV_WINDOW_AUTOSIZE );	
	cvNamedWindow( windowNameLaplace, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameSobelX, sobelXImage8 );
	cvShowImage( windowNameSobleY, sobelYImage8 );
	cvShowImage( windowNameLaplace, laplaceImage8 );

	//	L[͂҂
    cvWaitKey(0);

	//	摜ۑ
	cvSaveImage( "image/sobelx.bmp", sobelXImage8 );
	cvSaveImage( "image/sobely.bmp", sobelYImage8 );	
	cvSaveImage( "image/laplace.bmp", laplaceImage8 );
	 
	// 
	cvReleaseImage( &grayImage);
	cvReleaseImage( &sobelXImage16 );
	cvReleaseImage( &sobelYImage16 );
	cvReleaseImage( &laplaceImage16 );
	cvReleaseImage( &sobelXImage8 );
	cvReleaseImage( &sobelYImage8 );
	cvReleaseImage( &laplaceImage8 );
	//EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameSobelX );
	cvDestroyWindow( windowNameSobleY );
	cvDestroyWindow( windowNameLaplace );
	
	return 0;
}
