//---------------------------------------------------------------------
//Tv		: 摜̗̂̕֊s𒊏o
//File Name	: findcontours.cpp
//Library	: OpenCV for MS-Windows 1.0
//---------------------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <highgui.h>

#define THRESHOLD	10			//	2l̍ۂ臒l
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

#define CONTOUR_MAX_LEVEL	1	//	`悳֊s̍ő僌x
#define LINE_THICKNESS	2		//	̑
#define LINE_TYPE	8			//	̎

int main( int argc, char** argv ) {
	char windowNameSource[] = "Source";		//	ǂݍ񂾉摜\EBhE̖O
	char windowNameContour[] = "Contour";	//	֊s摜\EBhE̖O

	//	摜ǂݍ
	IplImage *sourceImage = cvLoadImage( "image/source.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}
	//	摜𐶐
	IplImage *grayImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );		//	O[XP[摜pIplImage
	IplImage *binaryImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );	//	2l摜pIplImage
	IplImage *contourImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 3 );	//	֊s摜pIplImage

	//	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	O[XP[2lɕϊ
	cvThreshold( grayImage, binaryImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	摜Rs[
	contourImage = cvCloneImage( sourceImage );

	//	֊sop̃mۂ
	CvMemStorage* storage = cvCreateMemStorage( 0 );	//	oꂽ֊sۑ̈
	CvSeq* find_contour = NULL;		//	֊sւ̃|C^           

	//	2l摜̗֊sA̐Ԃ
	int find_contour_num = cvFindContours( 
		binaryImage,			//	͉摜(WrbgVO`lj
		storage,				//	oꂽ֊sۑ̈
		&find_contour,			//	ԊO̗֊sւ̃|C^ւ̃|C^
		sizeof( CvContour ),	//	V[PXwb_̃TCY
		CV_RETR_LIST,			//	o[h 
		CV_CHAIN_APPROX_NONE,	//	@
		cvPoint( 0, 0 )			//	ItZbg
	);

	//	̗̂֊sԐFŕ`悷
	CvScalar red = CV_RGB( 255, 0, 0 );
	cvDrawContours( 
		contourImage,			//	֊s`悷摜
		find_contour,			//	ŏ̗֊sւ̃|C^
		red,					//	O֊s̐F
		red,					//	֊sij̐F
		CONTOUR_MAX_LEVEL,		//	`悳֊s̍ő僌x
		LINE_THICKNESS,			//	`悳֊s̑
		LINE_TYPE,				//	̎
		cvPoint( 0, 0 )			//	ItZbg
	);   

	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameContour, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameContour, contourImage );

	//	L[͂҂
	cvWaitKey( 0 );

	//	摜ۑ
	cvSaveImage( "image/contour.bmp", contourImage );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &binaryImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &contourImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameContour );

	return 0;
}