//---------------------------------------------------------------------
//Tv		:qXgO
//File Name	:histogram.cpp
//Library	:OpenCV for MS-Windows 1.0
//---------------------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <highgui.h>

#define DIMENSIONS	1				//	qXgO̎
#define UNIFORM	1					//	lɊւtO
#define	ACCUMULATE	0				//	vZtO
#define SCALE_SHIFT	0				//	XP[O͔z̗vfɉl

#define HISTOGRAM_WIDTH	512			//	qXgO`摜̉
#define HISTOGRAM_HEIGHT	100		//	qXgO`摜̏c

#define TRACKBAR_MAX_VALUE	200		//	gbNo[̍ől

#define LINE_THICKNESS	-1			//	̑
#define	LINE_TYPE	8				//	̎
#define SHIFT	0					//	W̏_ȉ̌\rbg

CvMat* lookUpTableMatrix;			//	ZxΉs
unsigned char lookUpTable[256];		//	ZxΉ\
CvHistogram *histogram;				//	qXgO

int histogramSize = 128;			//	qXgOɕ`悳c_̐
int trackbarBrightness = 100;		//	gbNo[ł̋Px̕\ʒȕl
int trackbarContrast = 100;			//	gbNo[ł̃RgXg̕\ʒȕl

float range_0[] = { 0, 256 };		//	qXgO͈̔
float* ranges[] = { range_0 };		//	qXgOe͈̔͂z̃|C^

IplImage *grayImage = NULL;			//	O[XP[摜pIplImage
IplImage *destinationImage = NULL;	//	ʏo͗pIplImage
IplImage *histogramImage = NULL;	//	qXgO摜pIplImage

char windowNameDestination[] = "Destination";	//	ʂ\EBhE̖O
char windowNameHistogram[] = "Histogram";		//	qXgO\EBhE̖O

//
//	gbNo[̒lςɌĂ΂֐
//
//	:
//		pos : gbNo[̒l
//
void changeBrightnessAndContrast( int pos ) {
	
    int brightness = trackbarBrightness - TRACKBAR_MAX_VALUE / 2;	//	Pxl
    int contrast = trackbarContrast - TRACKBAR_MAX_VALUE / 2;		//	RgXg
    int bin_w;														//	qXgȌc_̉
    float max_value = 0;											//	qXgO̍ől

	//	ZxΉ\𐶐
    if ( contrast > 0 ) {
        double delta = 127.0 * contrast / 100.0;
        double a = 255.0 / ( 255.0 - delta * 2 );
        double b = a * ( brightness - delta );
        for (int i = 0; i < 256; i++ ){
			//	ϊ̊K߂
            int v = cvRound( a * i + b );
			if( v < 0 ){
                v = 0;
			}
			if( v > 255 ){
                v = 255;
			}
            lookUpTable[i] = ( unsigned char )v;
        }
    } else {
        double delta = -128.0 * contrast / 100.0;
        double a = (256.0 - delta * 2.0) / 255.0;
        double b = a * brightness + delta;
        for(int i = 0; i < 256; i++ ){
            int v = cvRound( a * i + b);
			if( v < 0 ){
                v = 0;
			}
			if( v > 255 ){
                v = 255;
			}
            lookUpTable[i] = ( unsigned char )v;
        }
    }

	//	ZxΉspZxKϊs
	cvLUT( grayImage, destinationImage, lookUpTableMatrix );

	//	摜\
	cvShowImage( windowNameDestination, destinationImage );

	//	摜̃qXgOvZ
    cvCalcHist( &destinationImage, histogram, ACCUMULATE, NULL );
		
	//	qXgOl̍ől𓾂
    cvGetMinMaxHistValue( histogram, NULL, &max_value, NULL, NULL );
    
	//	qXgOőlɂĐK
	cvConvertScale( histogram->bins, histogram->bins, 
		( ( double )histogramImage->height ) / max_value, SCALE_SHIFT );

	//	qXgO摜𔒂ŏ
	cvSet( histogramImage, cvScalarAll( 255 ), NULL );

	//	qXgȌc_̉vZ
    bin_w = cvRound( ( double )histogramImage->width / histogramSize );

	//	qXgȌc_`悷
	for ( int i = 0; i < histogramSize; i++ ) {
        cvRectangle(
			histogramImage,
			cvPoint( i * bin_w, histogramImage->height ),
			cvPoint( ( i + 1 ) * bin_w,histogramImage->height - cvRound( cvGetReal1D( histogram->bins, i) ) ),
			cvScalarAll( 0 ),
			LINE_THICKNESS,
			LINE_TYPE,
			SHIFT
		);
	}
  	//	摜\
    cvShowImage( windowNameHistogram, histogramImage );
}

int main( int argc, char **argv ){
	char windowNameGray[] = "Gray";					//	O[XP[摜\EBhE̖O
	char trackbarNameBrightness[] = "Brightness";	//	PxύXgbNo[̖O
	char trackbarNameContrast[] = "Contrast";		//	RgXgύXgbNo[̖O

	//	摜ǂݍ
    IplImage *sourceImage = cvLoadImage( "image/baboon.jpg", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if( sourceImage == NULL ){
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
	grayImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );
	destinationImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 1 );
	histogramImage = cvCreateImage( cvSize( HISTOGRAM_WIDTH,HISTOGRAM_HEIGHT ), IPL_DEPTH_8U, 1 );
	
	//	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	摜Rs[
	destinationImage = cvCloneImage( grayImage );

	//	qXgO𐶐
	histogram = cvCreateHist( DIMENSIONS, &histogramSize, CV_HIST_ARRAY, ranges, UNIFORM );

	//	s𐶐
	lookUpTableMatrix = cvCreateMatHeader( 1, 256, CV_8UC1 );

	//	ZxΉsɔZxΉ\Zbg
	cvSetData( lookUpTableMatrix, lookUpTable, NULL );

	//	EBhE𐶐
	cvNamedWindow( windowNameGray, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDestination, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameHistogram, CV_WINDOW_AUTOSIZE );

	//	摜\
    cvShowImage( windowNameGray, grayImage );

	//	gbNo[𐶐
	cvCreateTrackbar( trackbarNameBrightness, windowNameDestination, &trackbarBrightness, 
		TRACKBAR_MAX_VALUE, changeBrightnessAndContrast );
    cvCreateTrackbar( trackbarNameContrast, windowNameDestination, &trackbarContrast, 
		TRACKBAR_MAX_VALUE, changeBrightnessAndContrast );

	changeBrightnessAndContrast( 0 );

	//	L[͂҂
	cvWaitKey( 0 );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &destinationImage );
	cvReleaseImage( &histogramImage );
	//	EBhEj
	cvDestroyWindow( windowNameGray );
	cvDestroyWindow( windowNameDestination );
	cvDestroyWindow( windowNameHistogram );

	return 0;
}