//---------------------------------------------------------
// Tv      : JLu[V
// File Name : calibration.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include "calibration.h"

CvCapture *capture = NULL;	//	JLv`p̍\

char windowNameCapture[] = "Capture"; 				//	Lv`摜\EBhE̖O
char windowNameUndistortion[] = "Undistortion";		//	Yc݂␳摜\EBhE̖O

//
//	sʂɕ\
//
//	:
//		disp   : \鐔l̏
//		matrix : \s
//
void printMatrix( char *disp, CvMat *matrix ) {
    for ( int y=0; y < matrix->height; y++ ) {
        for ( int x=0; x < matrix->width; x++ ) {
            printf( disp, cvmGet( matrix, y, x ) ); 
        }
        printf( "\n" );
    }
    printf( "\n" );
}

//
//	Op[^sʂɕ\
//
//	:
//		rotationMatrix    :  ]s
//		translationVector :@ixNg
//
void printExtrinsicMatrix( CvMat *rotationMatrix, CvMat *translationVector ) {
	for ( int i = 0; i<3; i++ ) {
		printf(
			"%lf %lf %lf %lf\n",
			cvmGet( rotationMatrix, i, 0 ),
			cvmGet( rotationMatrix, i, 1 ),
			cvmGet( rotationMatrix, i, 2 ),
			cvmGet( translationVector, 0, i )
		);
	}
}

//
//	cvFindChessboardCornersp̃tO𐶐
//
int createFindChessboardCornersFlag() {
	int flag = 0;

	if ( ADAPTIVE_THRESH != 0 ) {
		flag = flag | CV_CALIB_CB_ADAPTIVE_THRESH;
	}
	if ( NORMALIZE_IMAGE != 0 ) {
		flag = flag | CV_CALIB_CB_NORMALIZE_IMAGE;
	}
	if ( FILTER_QUADS != 0 ) {
		flag = flag | CV_CALIB_CB_FILTER_QUADS;
	}

	return flag;
}

//
//	R[i[o
//
//	:
//      frameImage : Lv`摜pIplImage
//      grayImage  : O[XP[摜pIplImage
//      corners    : R[i[̈ʒui[ϐ
//
//	߂l:
//		0   : R[i[ׂČołȂꍇ
//		0 : R[i[ׂČoꂽꍇ
//
int findCorners( IplImage *frameImage, IplImage *grayImage, CvPoint2D32f *corners ) {
	int cornerCount;				//	oR[i[̐
	int findChessboardCornersFlag;	//	cvFindChessboardCornersptO
	int findFlag;					//	R[i[ׂČoł̃tO

	//	cvChessboardCornersptO𐶐
	findChessboardCornersFlag = createFindChessboardCornersFlag();

	//	R[i[o
	findFlag=cvFindChessboardCorners(
		frameImage,
		cvSize( CORNER_WIDTH, CORNER_HEIGHT ),
		corners,
		&cornerCount,
		findChessboardCornersFlag
	);
	
	if( findFlag != 0 ) {
		//	R[i[ׂČoꂽꍇ
		//	oꂽR[i[̈ʒuTusNZPʂɂ
		cvCvtColor( frameImage, grayImage, CV_BGR2GRAY );
		CvTermCriteria criteria={ CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, MAX_ITERATIONS, EPSILON };
		cvFindCornerSubPix(
			grayImage,
			corners,
			cornerCount,
			cvSize( SEARCH_WINDOW_HALF_WIDTH, SEARCH_WINDOW_HALF_HEIGHT ),
			cvSize( DEAD_REGION_HALF_WIDTH, DEAD_REGION_HALF_HEIGHT ), 
			cvTermCriteria( CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, MAX_ITERATIONS, EPSILON )
		);
	}

	//	R[i[̈ʒu`
	cvDrawChessboardCorners( frameImage, cvSize( CORNER_WIDTH, CORNER_HEIGHT ), corners, cornerCount, findFlag );

	return findFlag;
}


//
//	Jp[^𐄒肷
//
//	:
//      intrinsicMatrix       : p[^s
//      distortionCoefficient : Yc݌W
//
//	߂l:
//		0 :	vOIꍇ
//		1 :	`FbNp^[BIꍇ
//
int estimateCameraParameters( CvMat *intrinsicMatrix, CvMat *distortionCoefficient ) {

	int captureCount = 0;	//	Lv``FbNp^[̖
	int returnValue = 0;	//	߂lpϐ
	int findFlag;			//	R[i[ׂČoł̃tO
	int key;				//	L[͗p̕ϐ

	CvPoint2D32f corners[CORNER_NUMBER];	//	R[i[̈ʒui[ϐ

	//	摜𐶐
	IplImage *frameImage = cvQueryFrame( capture );										//	Lv`摜pIplImage
	IplImage *grayImage = cvCreateImage( cvGetSize( frameImage ), IPL_DEPTH_8U, 1 );	//	O[XP[摜pIplImage

	//	s𐶐
	CvMat *worldCoordinates = cvCreateMat( CORNER_NUMBER * CAPTURE_NUMBER, 3, CV_64FC1 );	//	EWps
	CvMat *imageCoordinates = cvCreateMat( CORNER_NUMBER * CAPTURE_NUMBER, 2, CV_64FC1 );	//	摜Wps
	CvMat *pointCounts = cvCreateMat( CAPTURE_NUMBER, 1, CV_32SC1 );						//	R[i[i[s
	CvMat *rotationVectors = cvCreateMat( CAPTURE_NUMBER, 3, CV_64FC1 );					//	]xNg
	CvMat *translationVectors = cvCreateMat( CAPTURE_NUMBER, 3, CV_64FC1 );					//	ixNg

	//	EWݒ肷
	for ( int i = 0; i < CAPTURE_NUMBER; i++){
		for ( int j = 0; j < CORNER_NUMBER; j++){
			cvSetReal2D( worldCoordinates, i * CORNER_NUMBER + j, 0, ( j % CORNER_WIDTH ) * UNIT );
			cvSetReal2D( worldCoordinates, i * CORNER_NUMBER + j, 1, ( j / CORNER_WIDTH ) * UNIT );
			cvSetReal2D( worldCoordinates, i * CORNER_NUMBER + j, 2, 0.0 ); 
		}
	}

	//	R[i[ݒ肷
	for ( int i = 0; i < CAPTURE_NUMBER; i++){
		cvSetReal2D( pointCounts, i, 0, CORNER_NUMBER );
	}

	while ( 1 ) {
		frameImage = cvQueryFrame(capture);

		//	R[i[o
		findFlag = findCorners( frameImage, grayImage, corners );

		key=cvWaitKey( 1 );
		if ( key == ' ' ) {
			//	Xy[XL[ꂽ
			if ( findFlag != 0 ) {
				//	R[i[ׂČoꂽꍇ
				//	摜Wݒ肷
				for ( int i = 0; i < CORNER_NUMBER; i++){
					cvSetReal2D( imageCoordinates, captureCount * CORNER_NUMBER + i, 0, corners[i].x );
					cvSetReal2D( imageCoordinates, captureCount * CORNER_NUMBER + i, 1, corners[i].y );
				}

				captureCount++;

				printf( "%dڃLv`܂\n",captureCount );

				if ( captureCount == CAPTURE_NUMBER ) {
					//	ݒ肵񐔃`FbNp^[Bꍇ
					//	Jp[^𐄒肷
					cvCalibrateCamera2(
						worldCoordinates,
						imageCoordinates,
						pointCounts,
						cvGetSize( frameImage ),
						intrinsicMatrix,
						distortionCoefficient,
						rotationVectors,
						translationVectors,
						CALIBRATE_CAMERA_FLAG
					);

					printf( "\nYc݌W\n" );
					printMatrix( "%lf ", distortionCoefficient );
					printf( "\np[^\n" );
					printMatrix( "%lf ", intrinsicMatrix );

					returnValue = 1;
					break;
				}
			}
		} else if ( key == 'q' ) {
			//	'q'L[ꂽ
			returnValue = 0;
			break;
		}

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
	}

	//	
	cvReleaseMat( &worldCoordinates );
	cvReleaseMat( &imageCoordinates );
	cvReleaseMat( &pointCounts );
	cvReleaseMat( &rotationVectors );
	cvReleaseMat( &translationVectors );
	cvReleaseImage( &grayImage );

	return returnValue;
}

//
//	Op[^𐄒肷
//
//	:
//      intrinsicMatrix       : p[^s
//      distortionCoefficient : Yc݌W
//
void estimateExtrinsicParameters( CvMat *intrinsicMatrix, CvMat *distortionCoefficient ) {

	int key;		//	L[͗p̕ϐ
	int findFlag;	//	R[i[SɌoł̃tO

	//	摜𐶐
	IplImage *frameImage = cvQueryFrame( capture );												//	Lv`摜pIplImage
	IplImage *grayImage =cvCreateImage( cvGetSize( frameImage ), IPL_DEPTH_8U, 1 );				//	O[XP[摜pIplImage
	IplImage *undistortionImage = cvCreateImage( cvGetSize( frameImage ), IPL_DEPTH_8U, 3 );	//	Yc݂␳摜pIplImage

	//	s𐶐
	CvMat *worldCoordinates = cvCreateMat( CORNER_NUMBER, 3, CV_64FC1 );	//	EWps
	CvMat *imageCoordinates = cvCreateMat( CORNER_NUMBER, 2, CV_64FC1 );	//	摜Wps
	CvMat *rotationVector = cvCreateMat( 1, 3, CV_64FC1 );					//	]xNg
	CvMat *rotationMatrix = cvCreateMat( 3, 3, CV_64FC1 );					//	]s
	CvMat *translationVector = cvCreateMat( 1, 3, CV_64FC1 );				//	ixNg

	CvPoint2D32f corners[CORNER_NUMBER];	//	R[i[̈ʒui[ϐ

	//	EBhE𐶐
	cvNamedWindow( windowNameUndistortion, CV_WINDOW_AUTOSIZE );

	//	EWݒ肷
	for ( int i = 0; i < CORNER_NUMBER; i++){
		cvSetReal2D( worldCoordinates, i, 0, ( i % CORNER_WIDTH ) * UNIT );
		cvSetReal2D( worldCoordinates, i, 1, ( i / CORNER_WIDTH ) * UNIT );
		cvSetReal2D( worldCoordinates, i, 2, 0.0 );
	}

	while ( 1 ) {
		frameImage = cvQueryFrame( capture );

		//	R[i[o
		findFlag = findCorners( frameImage, grayImage ,corners );

		//	Yc݂␳摜𐶐
		cvUndistort2(
			frameImage,
			undistortionImage,
			intrinsicMatrix,
			distortionCoefficient
		);

		key=cvWaitKey( 1 );
		if ( key == ' ' ) {
			//	Xy[XL[ꂽ
			if ( findFlag != 0 ) {
				//	R[i[ׂČoꂽꍇ
				//	摜Wݒ肷
				for ( int i = 0; i < CORNER_NUMBER; i++ ){
					cvSetReal2D( imageCoordinates, i, 0, corners[i].x);
					cvSetReal2D( imageCoordinates, i, 1, corners[i].y);
				}

				//	Op[^𐄒肷
				cvFindExtrinsicCameraParams2(
					worldCoordinates,
					imageCoordinates,
					intrinsicMatrix,
					distortionCoefficient,
					rotationVector,
					translationVector
				);

				//	]xNg]sɕϊ
				cvRodrigues2( rotationVector, rotationMatrix, NULL );

				printf( "\nOp[^\n" );
				printExtrinsicMatrix( rotationMatrix, translationVector );
			}
		} else if ( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		}

		cvFlip( undistortionImage, undistortionImage );

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		cvShowImage( windowNameUndistortion, undistortionImage );
	}

	//	
	cvReleaseMat( &worldCoordinates );
	cvReleaseMat( &imageCoordinates );
	cvReleaseMat( &rotationVector );
	cvReleaseMat( &rotationMatrix );
	cvReleaseMat( &translationVector );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &undistortionImage );
}

int main(){

	//	s𐶐
	CvMat *intrinsicMatrix = cvCreateMat( 3, 3, CV_64FC1 );			//	p[^ps
	CvMat *distortionCoefficient = cvCreateMat( 4, 1, CV_64FC1 );	//	Yc݌Wps

	if ( CAPTURE_NUMBER < 3 ) {
		printf( "`FbNp^[3ȏBeĂ\n" );
	}								

	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ) {
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}

	//	EBhE𐶐
	cvNamedWindow( windowNameCapture, CV_WINDOW_AUTOSIZE );

	if ( estimateCameraParameters( intrinsicMatrix, distortionCoefficient ) != 0 ) {
		estimateExtrinsicParameters( intrinsicMatrix, distortionCoefficient );
	}

	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseMat( &intrinsicMatrix );
	cvReleaseMat( &distortionCoefficient );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameUndistortion );

	return 0;
}