//---------------------------------------------------------
// Tv      : Kzfpwi@
// File Name : sgm.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define	NUM_OF_BACKGROUND_FRAMES	50	//	wif𐶐̂Ɏgp摜̖
#define	THRESHOLD_COEFFICIENT		5.0	//	臒l߂ۂɎgpW΍ɂ鐔

#define	CONSTANT_THRESHOLD	20	//	摜1臒lgۂ臒l
#define CONSTANT_MODE		0	//	摜Ŝ1臒lptOl
#define DYNAMIC_MODE		1	//	fƂ臒l݂tOl

CvCapture *capture = NULL;	//	JLv`p̍\

IplImage *backgroundAverageImage = NULL;	//	wi̕ϒlۑpIplImage
IplImage *backgroundThresholdImage = NULL;	//	wi臒lۑpIplImage

//
//	摜㉺]ĕ\
//
//	:
//		windowName : 摜\EBhE̖O
//		image      : ㉺]ĕ\摜pIplImage
//
void showFlipImage( char *windowName, IplImage *image ) {
	if ( image->origin == 0 ) {
		cvFlip( image, image, 0 );
		cvShowImage( windowName, image );
		cvFlip( image, image, 0 );
	}
}

//
//	wif
//
//	:
//		num  : wif𐶐̂Ɏgp摜̖
//		size : 摜TCY
//
void initializeBackgroundModel( int num, CvSize size ){
	int i;

	// ȑO̔wi񂪂Δj
	if( backgroundAverageImage != NULL ){
		cvReleaseImage( &backgroundAverageImage );
	}
	if( backgroundThresholdImage != NULL ){
		cvReleaseImage( &backgroundThresholdImage );
	}

	//	摜~ϗpobt@mۂ
	IplImage *acc = cvCreateImage( size, IPL_DEPTH_32F, 3 );
	IplImage *acc2 = cvCreateImage( size, IPL_DEPTH_32F, 3 );
	
	//	摜̏s
	cvSetZero( acc );
	cvSetZero( acc2 );

	//	摜̒~
	printf( "wi擾...\n" );
	IplImage *frameImage;
	for( i = 0; i < num; i++ ){
		frameImage = cvQueryFrame( capture );
		cvAcc( frameImage, acc );
		cvSquareAcc( frameImage, acc2 );
		printf( "%d  %d \n", num, i + 1 );
	}
	printf( "wi擾\n" );

	//	cvAddS, cvSubS ͂邪 cvMulS ͂Ȃ̂ŁAcvConvertScale g
	cvConvertScale( acc, acc, 1.0 / num );		// 
	cvConvertScale( acc2, acc2, 1.0 / num );	// a̕

	//	ς܂̂ backgroundAverageImage Ɋi[B
	backgroundAverageImage = cvCreateImage( size, IPL_DEPTH_8U, 3 );
	cvConvert( acc, backgroundAverageImage );

	//	UvZ
	IplImage *dispersion = cvCreateImage( size, IPL_DEPTH_32F, 3 );
	cvMul( acc, acc, acc );
	cvSub( acc2, acc, dispersion );

	//	W΍vZ
	IplImage *sd = cvCreateImage( size, IPL_DEPTH_32F, 3 );
	cvPow( dispersion, sd, 0.5 );

	//	臒lvZ
	backgroundThresholdImage = cvCreateImage( size, IPL_DEPTH_8U, 3 );
	cvConvertScale( sd, backgroundThresholdImage, THRESHOLD_COEFFICIENT );

	//	
	cvReleaseImage( &acc );
	cvReleaseImage( &acc2 );
	cvReleaseImage( &dispersion );
	cvReleaseImage( &sd );
}

int main( void ){ 
	int key;		//	L[͗p̕ϐ
	int	mode = 0;	// 0: fƂɈقȂ臒l / 1: 摜Ŝň臒l

	char *windowNameCapture = "Capture";		//	Lv`摜\EBhE̖O
	char *windowNameResult  = "Result";			//	wiʂ\EBhE̖O
	char *windowNameBackground = "Background";	//	wi摜\EBhE̖O
	char *windowNameThreshold = "Threshold";	//	臒l\EBhE̖O

	IplImage *frameImage;		//	Lv`摜pIplImage
	IplImage *differenceImage;	//	摜pIplImage
	IplImage *resultImage;		//	ʉ摜pIplImage

	char *mode_str[2] = {
		"fP",
		"摜ň"
	};

	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ){
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}
	
	//	EBhE𐶐
	cvNamedWindow( windowNameCapture, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameResult, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameBackground, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameThreshold, CV_WINDOW_AUTOSIZE );

	//	J̌t[摜Lv`
	frameImage = cvQueryFrame( capture );

	//	摜TCYۑ
	CvSize imageSize = cvSize( frameImage->width, frameImage->height );

	//	2lʊi[p摜mۂ
	differenceImage = cvCloneImage( frameImage );
	resultImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );
								 
	//	wif
	initializeBackgroundModel( NUM_OF_BACKGROUND_FRAMES, imageSize );

	while ( 1 ){
		frameImage = cvQueryFrame( capture );

		//	݂̔wiƂ̍̐Βl𐬕ƂɎ
		cvAbsDiff( frameImage, backgroundAverageImage, differenceImage );

		//	Sub ̓}CiXɂȂ0ɐ؂l߂Ă
		if( mode == 0 ){
			cvSub( differenceImage, backgroundThresholdImage, differenceImage );
		} else{
			cvSubS( differenceImage, cvScalarAll( CONSTANT_THRESHOLD ), differenceImage );
		}

		//	differenceImage ̗vf1ł0ȏゾOi
		cvCvtColor( differenceImage, resultImage, CV_BGR2GRAY );
        cvThreshold( resultImage, resultImage, 0, 255, CV_THRESH_BINARY );
		
		//	fBAtB^ŃmCY
		cvSmooth( resultImage, resultImage, CV_MEDIAN );

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		showFlipImage( windowNameResult, resultImage );
		showFlipImage( windowNameBackground, backgroundAverageImage );

		IplImage *tmp = cvCloneImage( backgroundThresholdImage );
		cvConvertScale( tmp, tmp, 3 );
		showFlipImage( windowNameThreshold, tmp );
		cvReleaseImage( &tmp );

		//	L[͔
		key = cvWaitKey( 1 );
		if( key == 'q' ){
			//	'q'L[ꂽ烋[v𔲂
			break;
		} else if( key == 'b' ){
			//	'b'L[ꂽ炻̎_ł̉摜wi摜Ƃ
			initializeBackgroundModel( NUM_OF_BACKGROUND_FRAMES, imageSize );
			printf( "wiXV\n" );
		} else if( key == 'm' ){
			//	'm'L[ꂽ臒l̐ݒ@ύX
			mode = 1 - mode;
			printf( "臒l: %s\n", mode_str[mode] );
		}
	}
	
	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &differenceImage );
	cvReleaseImage( &resultImage );
	cvReleaseImage( &backgroundAverageImage );
	cvReleaseImage( &backgroundThresholdImage );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameResult );
	cvDestroyWindow( windowNameBackground );
	cvDestroyWindow( windowNameThreshold );

	return 0;
}