//---------------------------------------------------------
// Tv      : IȔwi̍XV܂ޔwi@
// File Name : bbs3.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define	MASK_THRESHOLD		1	//	backgroundMaskImagestillObjectMaskImage𐶐邽߂臒l
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

#define	BACKGROUND_ALPHA				0.01	//	wiXV̍ۂ̍䗦
#define	BACKGROUND_INITIAL_THRESHOLD	20		//	wȉ臒l

#define	STILL_OBJECT_ALPHA				0.1		//	Î~̍XV̍ۂ̍䗦
#define	STILL_OBJECT_INITIAL_THRESHOLD	255		//	Î~̂̏臒l

#define	THRESHOLD_COEFFICIENT	5.0	//	臒l̒lۂ̎gp臒lɂ鐔

#define	NOT_STILL_DEC_STEP			10	//	ꍇ̃JE^Z
#define	STILL_OBJECT_TO_BACKGROUND	100	//	wiƂč̗p

//
//	摜㉺]ĕ\
//
//	:
//		windowName : 摜\EBhE̖O
//		image      : ㉺]ĕ\摜pIplImage
//
void showFlipImage( char *windowName, IplImage *image ) {
	if ( image->origin == 0 ) {
		cvFlip( image, image, 0 );
		cvShowImage( windowName, image );
		cvFlip( image, image, 0 );
	}
}

int main( int argc, char **argv ) { 
	int key;					//	L[͗p̕ϐ
	CvCapture *capture = NULL;	//	JLv`p̍\

	char *windowNameCapture = "Capture";					//	Lv`摜\EBhE̖O
	char *windowNameForeground  = "Foreground Mask";		//	Oi}XN摜\EBhE̖O
	char *windowNameStillObjectMask  = "Still Object Mask";	//	Î~̃}XN摜\EBhE̖O
	char *windowNameBackground = "Background";				//	wi摜\EBhE̖O
	char *windowNameStillObject  = "Still Object";			//	Î~̂\EBhE̖O
	char *windowNameCounter = "Counter";					//	JE^\EBhE̖O

	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ) {
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}
	
	//	EBhE𐶐
	cvNamedWindow( windowNameCapture, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameForeground, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameStillObjectMask, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameBackground, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameStillObject, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameCounter, CV_WINDOW_AUTOSIZE );

	IplImage *frameImage = cvQueryFrame( capture );

	//	摜TCYۑ
	CvSize imageSize = cvGetSize( frameImage );

	//	摜𐶐
	IplImage *backgroundAverageImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );		//	wi̕ϒlۑpIplImage
	IplImage *backgroundThresholdImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );		//	wi臒lۑpIplImage
	IplImage *stillObjectAverageImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );		//	Î~̂̕ϒlۑpIplImage
	IplImage *stillObjectThresholdImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );		//	Î~̂臒lۑpIplImage
	IplImage *stillObjectCounterImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );		//	Î~̂̃JE^pIplImage
	IplImage *backgroundDifferenceImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );		//	wi摜pIplImage
	IplImage *stillObjectDifferenceImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );	//	Î~̍摜pIplIMage
	IplImage *thresholdImage32 = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );				//	32bit臒l摜pIplImage
	IplImage *thresholdImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 3 );					//	臒l摜pIplImage
	IplImage *resultImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );					//	ʉ摜pIplImage
	IplImage *backgroundMaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );			//	wi}XN摜pIplImage
	IplImage *foregroundMaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );			//	Oi}XNpIplImage
	IplImage *stillObjectMaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );			//	Î~̃}XNpIplImage
	IplImage *movingObjectMask = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );				//	̃}XNpIplImage
	IplImage *backgroundCopyMaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );		//	wiɃRs[ۂɎgp}XNpIplImage
	IplImage *tmpMaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );					//	e|pIplImage
	IplImage *tmp2MaskImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );					//	e|pIplImage(2)
	IplImage *frameImage32 = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );					//	32bit̃Lv`摜pIplImage
	IplImage *backgroundImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 3 );				//	wi摜pIplImage
	IplImage *stillObjectImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 3 );				//	Î~̉摜pIplImage

	//	
	cvConvert( frameImage, backgroundAverageImage );
	cvSet( backgroundThresholdImage, cvScalarAll( BACKGROUND_INITIAL_THRESHOLD ) );
	cvSetZero( stillObjectAverageImage );
	cvSetZero( stillObjectThresholdImage );
	cvSetZero( stillObjectCounterImage );
								 
	while ( 1 ) {
		frameImage = cvQueryFrame( capture );

		//	float 32bitɕϊ
		cvConvert( frameImage, frameImage32 );

		//	wiƂ̍ /////////////////////////////////////////////////////////

		//	݂̔wiƂ̍̐Βl𐬕ƂɎ
		cvAbsDiff( frameImage32, backgroundAverageImage, backgroundDifferenceImage );

		//	臒l̒l
		cvAddWeighted( backgroundDifferenceImage, 1.0, backgroundThresholdImage, -THRESHOLD_COEFFICIENT, 0.0, thresholdImage32 );

		// thresholdImage ̗vf1ł0ȏゾwił͂Ȃ
		cvConvert( thresholdImage32, thresholdImage );
		cvCvtColor( thresholdImage, resultImage, CV_BGR2GRAY );
        cvThreshold( resultImage, backgroundMaskImage, MASK_THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY_INV );

		//	wiƂ̍ /////////////////////////////////////////////////////

		//	݂̔wiƂ̍̐Βl𐬕ƂɎ
		cvAbsDiff( frameImage32, stillObjectAverageImage, stillObjectDifferenceImage );

		//	臒l̒l
		cvAddWeighted( stillObjectDifferenceImage, 1.0, stillObjectThresholdImage, -THRESHOLD_COEFFICIENT, 0.0, thresholdImage32 );

		//	thresholdImage ̗vf1ł0ȏゾwił͂Ȃ
		cvConvert( thresholdImage32, thresholdImage );
		cvCvtColor( thresholdImage, resultImage, CV_BGR2GRAY );
        cvThreshold( resultImage, stillObjectMaskImage, MASK_THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY_INV );
		
		//	܂łŁA
		//	backgroundDifferenceImage, backgroundMaskImage
		//	stillObjectDifferenceImage, stillObjectMaskImage
		//	ɈӖ̂lB

		//	eXV /////////////////////////////////////////////////

		//	wiɓꍇ (backgroundMaskImage=1̏ꍇ)
		cvRunningAvg( frameImage32, backgroundAverageImage, BACKGROUND_ALPHA, backgroundMaskImage );
		cvRunningAvg( backgroundDifferenceImage, backgroundThresholdImage, BACKGROUND_ALPHA, backgroundMaskImage );

		//	wiɓꍇ (backgroundMaskImage=0 && stillObjectMaskImage=1)
		cvNot( backgroundMaskImage, foregroundMaskImage );
		cvAnd( foregroundMaskImage, stillObjectMaskImage, tmpMaskImage );	//	wi
		
		cvRunningAvg( frameImage32, stillObjectAverageImage, STILL_OBJECT_ALPHA, tmpMaskImage );
		cvRunningAvg( stillObjectDifferenceImage, stillObjectThresholdImage, STILL_OBJECT_ALPHA, tmpMaskImage );
					  
		//	wiJE^𑝂₷
		cvAddS( stillObjectCounterImage, cvScalar( 1 ), stillObjectCounterImage, tmpMaskImage );
		
		//	JE^臒lȏɂȂAwiwiƂč̗p
		cvThreshold( stillObjectCounterImage, tmp2MaskImage, STILL_OBJECT_TO_BACKGROUND, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );
		cvAnd( tmpMaskImage, tmp2MaskImage, backgroundCopyMaskImage );
		cvCopy( stillObjectAverageImage, backgroundAverageImage, backgroundCopyMaskImage );
		cvCopy( stillObjectThresholdImage, backgroundThresholdImage, backgroundCopyMaskImage );

		//	 backgroundCopyMaskImage ́AŔwi0ɏۂɎgp
		cvSet( stillObjectCounterImage, cvScalarAll( 0 ), backgroundCopyMaskImage );

		//	wiłȂAwiłȂꍇ
		//	(foregroundMaskImage = 1 && stillObjectMaskImage = 0)
		cvNot( stillObjectMaskImage, movingObjectMask );
		
		//	JE^炷(Z,ԃmCYΉ)
		//	́AwiɕނꂽsNZɑ΂ĂsBȂ킿A
		//	movingObjectMask == 1 || backgroundMaskImage == 1
		cvOr( backgroundMaskImage, movingObjectMask, tmpMaskImage );
		cvSubS( stillObjectCounterImage, cvScalarAll( NOT_STILL_DEC_STEP ), stillObjectCounterImage, tmpMaskImage );
		
		//	JE^0ɂȂwi
		cvNot( stillObjectCounterImage, tmp2MaskImage );	// tmp2 = 1 Ȃ珉

		//	ľ2ނB
		//	(1)݂̉摜ŏ --- wiłȂwiłȂꍇ
		//	(2)o^ȂԂŏ --- wi͔wiRs[ꍇ
		//	ł(1)ŏĂ
		cvOr( tmpMaskImage, backgroundCopyMaskImage, tmpMaskImage );
		cvAnd( tmpMaskImage, tmp2MaskImage, tmpMaskImage );

		cvCopy( frameImage32, stillObjectAverageImage, tmpMaskImage );
		cvSet( stillObjectThresholdImage, cvScalarAll( STILL_OBJECT_INITIAL_THRESHOLD ), tmpMaskImage );
		
		//	mCY
		cvSmooth( foregroundMaskImage, foregroundMaskImage, CV_MEDIAN );

		cvConvert( backgroundAverageImage, backgroundImage );
		cvConvert( stillObjectAverageImage, stillObjectImage );

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		showFlipImage( windowNameForeground, foregroundMaskImage );
		showFlipImage( windowNameStillObjectMask, stillObjectMaskImage );
		showFlipImage( windowNameBackground, backgroundImage );
		showFlipImage( windowNameStillObject, stillObjectImage );
		showFlipImage( windowNameCounter, stillObjectCounterImage );

		//	L[͔
		key = cvWaitKey( 1 );
		if ( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		}
	}

	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &backgroundAverageImage );
	cvReleaseImage( &backgroundThresholdImage);
	cvReleaseImage( &stillObjectAverageImage );
	cvReleaseImage( &stillObjectThresholdImage );
	cvReleaseImage( &stillObjectCounterImage );
	cvReleaseImage( &backgroundDifferenceImage );
	cvReleaseImage( &stillObjectDifferenceImage );
	cvReleaseImage( &thresholdImage32 );
	cvReleaseImage( &thresholdImage );
	cvReleaseImage( &resultImage );
	cvReleaseImage( &backgroundMaskImage );
	cvReleaseImage( &foregroundMaskImage );
	cvReleaseImage( &stillObjectMaskImage );
	cvReleaseImage( &movingObjectMask );
	cvReleaseImage( &backgroundCopyMaskImage );
	cvReleaseImage( &tmpMaskImage );
	cvReleaseImage( &tmp2MaskImage );
	cvReleaseImage( &frameImage32 );
	cvReleaseImage( &backgroundImage );
	cvReleaseImage( &stillObjectImage );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameForeground );
	cvDestroyWindow( windowNameStillObjectMask );
	cvDestroyWindow( windowNameBackground );
	cvDestroyWindow( windowNameStillObject );
	cvDestroyWindow( windowNameCounter );

	return 0;
}
