//---------------------------------------------------------
// Tv      : łPȔwi@
// File Name : bbs1.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define	THRESHOLD			20				//	߂ۂ臒l
#define THRESHOLD_MAX_VALUE	255				//	2l̍ۂɎgpől
#define	SCALE				( 1.0 / 255.0 )	//	L*a*b*ɕϊ邽߂ɕKvȃXP[t@N^

#define CAPTURE_OFF			0	//	摜̃Lv`𒆎~tOl
#define CAPTURE_ON			1	//	摜̃Lv`JntOl
#define COLOR_DIFFERENCE	0	//	RGBeɂ鍷ZõtOl
#define LAB_DIFFERENCE		1	//	L*a*b*\Fnɂ鍷ZõtOl
#define GRAY_DIFFERENCE		2	//	O[XP[ɂ鍷ZõtOl
#define NOISE_KEEP			0	//	mCYȂtOl
#define	NOISE_MORPHOLOGY	1	//	tHW[ZɂmCỸtOl
#define NOISE_MEDIAN		2	//	fBAtB^ɂmCỸtOl

CvSize imageSize;	//	摜̃TCY

//
//	Ƃɕ]
//
//	:
//		currentImage    : ݂̉摜pIplImage
//		backgroundImage : wi摜pIplImage
//		resultImage     : ʉ摜pIplImage
//
void colorDifference( IplImage *currentImage, IplImage *backgroundImage, IplImage *resultImage ){

	//	摜𐶐
	IplImage *differenceImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 3 );	//	摜pIplImage
	IplImage *differenceRImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );	//	Rl̍pIplImage
	IplImage *differenceGImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );	//	Gl̍pIplImage
	IplImage *differenceBImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );	//	Bl̍pIplImage

	//	݂̔wiƂ̍̐Βl𐬕ƂɎ
	cvAbsDiff( currentImage, backgroundImage, differenceImage );

	//	臒ls
	cvThreshold( differenceImage, differenceImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	Ƃ̉摜ɕ
	cvSplit( differenceImage, differenceBImage, differenceGImage, differenceRImage, NULL );

	//	ORō
	cvOr( differenceRImage, differenceGImage, resultImage );
	cvOr( differenceBImage, resultImage, resultImage );

	//	
	cvReleaseImage( &differenceImage );
	cvReleaseImage( &differenceRImage );
	cvReleaseImage( &differenceGImage );
	cvReleaseImage( &differenceBImage );
}

//
//	L*a*b*ŋ]
//
//	:
//		currentImage    : ݂̉摜pIplImage
//		backgroundImage : wi摜pIplImage
//		resultImage     : ʉ摜pIplImage
//
void labDifference( IplImage *currentImage, IplImage *backgroundImage, IplImage *resultImage ){

	//	摜𐶐
	IplImage *currentLabImage = cvCreateImage( imageSize,IPL_DEPTH_32F, 3 );		//	݂̉摜L*a*b*ɕϊ摜pIplImage
	IplImage *backgroundLabImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );	//	wiL*a*b*ɕϊ摜pIplImage
	IplImage *differenceLabImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 3 );	//	摜pIplImage
	IplImage *differenceLImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 1 );		//	L*l̍pIplImage
	IplImage *differenceAImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 1 );		//	a*l̍pIplImage
	IplImage *differenceBImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 1 );		//	b*l̍pIplImage
	IplImage *sqrDifferenceImage = cvCreateImage( imageSize, IPL_DEPTH_32F, 1 );	//	ZopIplImage

	//	݂̉摜Ɣwi CIE L*a*b* ɕϊ
	cvConvertScale( currentImage, currentLabImage, SCALE );
	cvConvertScale( backgroundImage, backgroundLabImage, SCALE );
	cvCvtColor( currentLabImage, currentLabImage, CV_BGR2Lab );
	cvCvtColor( backgroundLabImage, backgroundLabImage, CV_BGR2Lab );

	//	̓vZ
	cvSub( currentLabImage, backgroundLabImage, differenceLabImage );
	cvPow( differenceLabImage, differenceLabImage, 2 );

	//	Ƃ̉摜ɕ
	cvSplit( differenceLabImage, differenceLImage, differenceAImage, differenceBImage, NULL );

	cvCopy( differenceLImage, sqrDifferenceImage );
	cvAdd( differenceAImage, sqrDifferenceImage, sqrDifferenceImage );
	cvAdd( differenceBImage, sqrDifferenceImage, sqrDifferenceImage );

	//	臒ls
	cvThreshold( sqrDifferenceImage, resultImage, THRESHOLD * THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	
	cvReleaseImage( &currentLabImage );
	cvReleaseImage( &backgroundLabImage );
	cvReleaseImage( &differenceLabImage );
	cvReleaseImage( &differenceLImage );
	cvReleaseImage( &differenceAImage );
	cvReleaseImage( &differenceBImage );
	cvReleaseImage( &sqrDifferenceImage );
}

//
//	O[XP[ŕ]
//
//	:
//		currentImage    : ݂̉摜pIplImage
//		backgroundImage : wi摜pIplImage
//		resultImage     : ʉ摜pIplImage
//
void grayScaleDifference( IplImage *currentImage, IplImage *backgroundImage, IplImage *resultImage ){

	//	摜𐶐
	IplImage *differenceImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 3 );	//	摜pIplImage

	//	݂̔wiƂ̍̐Βl𐬕ƂɎ
	cvAbsDiff( currentImage, backgroundImage, differenceImage );

	//	BGRO[XP[ɕϊ
	cvCvtColor( differenceImage, resultImage, CV_BGR2GRAY );

	//	O[XP[2lɕϊ
	cvThreshold( resultImage, resultImage, THRESHOLD, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	
	cvReleaseImage( &differenceImage );
}

int main( void ){
	int key;					//	L[͗p̕ϐ
	CvCapture *capture = NULL;	//	JLv`p̍\

	char windowNameCurrent[] = "Current";		//	݂̉摜\EBhE̖O
	char windowNameResult[] = "Result";			//	wiʂ\EBhE̖O
	char windowNameBackground[] = "Background";	//	wi摜\EBhE̖O

	IplImage *frameImage = NULL;		//	Lv`摜pIplImage
	IplImage *currentImage = NULL;		//	݂̉摜pIplImage
	IplImage *backgroundImage = NULL;	//	wi摜pIplImage
	IplImage *resultImage = NULL;		//	ʉ摜pIplImage

	int	captureOn = CAPTURE_ON;				//	wis摜XV邩ǂ
	int	differenceMode = COLOR_DIFFERENCE;	//	̌vZ[h
	int	noiseMode = NOISE_KEEP;				//	mCY郂[h

	char *differenceMethod[3] = {
		"RGB̐Ƃɕ]",
		"CIE L*a*b* ŋ]",
		"O[XP[ŕ]"
	};

	char *noiseMethod[3] = {
		"Ȃ",
		"I[vjO",
		"fBAtB^"
	};

	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ){
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}
	
	//	EBhE𐶐
	cvNamedWindow( windowNameCurrent, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameResult, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameBackground, CV_WINDOW_AUTOSIZE );

	//	摜1Lv`wiƂĕۑ
	frameImage = cvQueryFrame( capture );
	backgroundImage = cvCloneImage( frameImage );

	//	݂̉摜ƂĂ1mۂ
	currentImage = cvCloneImage( frameImage );

	//	摜TCYۑ
	imageSize = cvSize( frameImage->width, frameImage->height );

	//	2lʊi[p摜mۂ
	resultImage = cvCreateImage( imageSize, IPL_DEPTH_8U, 1 );
								 
	while( 1 ){
		frameImage = cvQueryFrame( capture );

		if( captureOn != 0){
			if( currentImage != NULL){
				cvReleaseImage( &currentImage );
			}
			currentImage = cvCloneImage( frameImage );
		}

		//	̌vZ@̐؂ւ
		if( differenceMode == COLOR_DIFFERENCE ){	
			//	Ƃɕ]
			colorDifference( currentImage, backgroundImage, resultImage );
		} else if( differenceMode == LAB_DIFFERENCE ){	
			//	L*a*b*ŋ]
			labDifference( currentImage, backgroundImage, resultImage );
		} else if( differenceMode == GRAY_DIFFERENCE ){
			//	O[XP[ŕ]
			grayScaleDifference( currentImage, backgroundImage, resultImage );
		}

		//	mCY
		if( noiseMode == NOISE_MORPHOLOGY ){
			cvErode( resultImage, resultImage );
			cvDilate( resultImage, resultImage );
		}else if ( noiseMode == NOISE_MEDIAN ){
			cvSmooth( resultImage, resultImage, CV_MEDIAN );
		}

		if( resultImage->origin == 0 ){
			//@オ_̏ꍇ
			cvFlip( resultImage, resultImage, 0 );
		}

		//	摜\
		cvShowImage( windowNameCurrent, currentImage );
		cvShowImage( windowNameResult, resultImage );
		cvShowImage( windowNameBackground, backgroundImage );

		//	L[͔
		key = cvWaitKey( 1 );
		if( key == 'q' ){
			//	'q'L[ꂽ烋[v𔲂
			break;
		} else if( key == 'b' ){
			//	'b'L[ꂽ炻̎_ł̉摜wi摜Ƃ
			if( backgroundImage != NULL ){
				cvReleaseImage( &backgroundImage );
			}
			backgroundImage = cvCloneImage( frameImage );
			printf( "wi摜XV\n" );
		} else if( key == ' ' ){
			//	Xy[XL[ꂽ摜擾ON/OFFύX
			captureOn = 1 - captureOn;
			if( captureOn == CAPTURE_ON ){
                printf( "摜擾: ON\n" );
			}else if( captureOn == CAPTURE_OFF ){
				printf( "摜擾: OFF\n" );
			}
		} else if( key == 'm' ){
			//	'm'L[ꂽ獷̕]@ύX
			differenceMode = differenceMode + 1;
			if( differenceMode > GRAY_DIFFERENCE ){
				differenceMode = COLOR_DIFFERENCE;
			}
			printf( "̕]@: %s\n", differenceMethod[differenceMode] );
		} else if( key == 'n' ){ 
			//	'n'L[ꂽmCY@ύX
			noiseMode = noiseMode + 1;
			if( noiseMode > NOISE_MEDIAN ){
				noiseMode = NOISE_KEEP;
			}
			printf( "mCY@: %s\n", noiseMethod[noiseMode] );
		}
	}

	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &backgroundImage );
	cvReleaseImage( &currentImage );
	cvReleaseImage( &resultImage );
	//	EBhEj
	cvDestroyWindow( windowNameCurrent );
	cvDestroyWindow( windowNameResult );
	cvDestroyWindow( windowNameBackground );

	return 0;
}
