//---------------------------------------------------------------------
//Tv		: 摜2l
//File Name	: binarization.cpp
//Library	: OpenCV for MS-Windows 1.0
//---------------------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define TRACKBAR_MAX_VALUE	255	//	gbNo[̍ől
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

IplImage *sourceImage;	//	摜pIplImage
IplImage *grayImage;	//	O[XP[摜pIplImage
IplImage *binaryImage;	//	2l摜pIplImage

char windowNameBinarization[] = "Binarization";	//	2l摜\EBhE̖O
int levels = 128;	//	gbNo[̒l(2l̍ۂ臒l)

//
//	2l摜ɕϊC\
//
void binarization( void ){
	//	BGRO[XP[ɕϊ
	cvCvtColor( sourceImage, grayImage, CV_BGR2GRAY );

	//	O[XP[2lɕϊ
	cvThreshold( grayImage, binaryImage, levels, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );

	//	摜\
	cvShowImage( windowNameBinarization, binaryImage );
}

//
//	gbNo[̒lςɌĂ΂֐
//
//	:
//		pos : gbNo[̒l
//
void on_change( int pos ){
	binarization();
}

int main( int argc, char **argv ){

	char trackbarNameThreshold[] = "Threshold";	//	2l̍ۂ臒lύXgbNo[̖O

	//	摜ǂݍ
	sourceImage = cvLoadImage( "image/lena.jpg",CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ){
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
	grayImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );
	binaryImage = cvCreateImage( cvGetSize(sourceImage), IPL_DEPTH_8U, 1 );
	
	//	EBhE𐶐
    cvNamedWindow( windowNameBinarization );

	//	gbNo[𐶐
	cvCreateTrackbar( trackbarNameThreshold,  windowNameBinarization, &levels,TRACKBAR_MAX_VALUE, on_change );
	binarization();

	//	L[͂҂
	cvWaitKey( 0 );
	
	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &binaryImage );
	//	EBhEj
	cvDestroyWindow( windowNameBinarization );

	return 0;
}