//---------------------------------------------------------
// Tv      : 摜̕sړs
// File Name : translate.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define TRANSLATE_X	100	//	Ẍړ
#define TRANSLATE_Y	100	//	Ÿړ

int main( int argc, char **argv ) {
	char windowNameSource[] = "Source";				//	摜\EBhE̖O
	char windowNameDestination[] = "Destination";	//	ϊ̉摜\EBhE̖O

	//	摜ǂݍ
	IplImage *sourceImage = cvLoadImage( "image/lena.jpg", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ){
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
	IplImage *destinationImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 3 );	//	ϊ̉摜pIplImage

	CvPoint2D32f original[3];	//	ϊOW
	CvPoint2D32f translate[3];	//	ϊW

	//ϊO̍Wݒ肷
	original[0] = cvPoint2D32f( 0, 0 );
	original[1] = cvPoint2D32f( sourceImage->width, 0 );
	original[2] = cvPoint2D32f( 0, sourceImage->height );

	//ϊ̍Wݒ肷
	translate[0] = cvPoint2D32f( TRANSLATE_X, TRANSLATE_Y );
	translate[1] = cvPoint2D32f( TRANSLATE_X + sourceImage->width, TRANSLATE_Y );
	translate[2] = cvPoint2D32f( TRANSLATE_X, TRANSLATE_Y + sourceImage->height );

	//	s𐶐
	CvMat *affineMatrix = cvCreateMat( 2, 3, CV_32FC1);

	//	ϊs߂
	cvGetAffineTransform( original, translate, affineMatrix );

	//	ϊs𔽉f
	cvWarpAffine( sourceImage, destinationImage, affineMatrix, CV_INTER_LINEAR | CV_WARP_FILL_OUTLIERS, cvScalarAll( 0 ) );

	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDestination, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameDestination, destinationImage );

	//	L[͂҂
	cvWaitKey( 0 );

	//	摜ۑ
	cvSaveImage( "image/destination.bmp", destinationImage );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &destinationImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameDestination );

  return 0;
}

