//---------------------------------------------------------
// Tv      : 摜̊gAks
// File Name : scale.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define SCALE_X 1.5		//	X̊g嗦
#define SCALE_Y 0.8		//	Y̊g嗦

int main( int argc, char **argv ) {
	char windowNameSource[] = "Source";				//	摜\EBhE̖O
	char windowNameDestination[] = "Destination";	//	ϊ̉摜\EBhE̖O

	//	摜ǂݍ
	IplImage *sourceImage = cvLoadImage( "image/lena.jpg", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ){
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}	

	//	摜𐶐
	IplImage *destinationImage = cvCreateImage( cvSize( ( int )( sourceImage->width * SCALE_X ), ( int )( sourceImage->height * SCALE_Y ) ), IPL_DEPTH_8U, 3 );	//	ϊ̉摜pIplImage

	//	摜̑傫ϊ
	cvResize( sourceImage, destinationImage, CV_INTER_LINEAR );

	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDestination, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameDestination, destinationImage );

	//	L[͂҂
	cvWaitKey( 0 );

	//	摜ۑ
	cvSaveImage( "image/destination.bmp", destinationImage );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &destinationImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameDestination );

  return 0;
}

