//---------------------------------------------------------
// Tv      : 摜̉]s
// File Name : rotate.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define ANGLE 60.0	//	]px
#define SCALE 0.8	//	摜̊g嗦

int main( int argc, char **argv ) {
	char windowNameSource[] = "Source";				//	摜\EBhE̖O
	char windowNameDestination[] = "Destination";	//	ϊ̉摜\EBhE̖O

	//	摜ǂݍ
	IplImage *sourceImage = cvLoadImage( "image/lena.jpg", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ){
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜𐶐
	IplImage *destinationImage = cvCreateImage( cvGetSize( sourceImage ), IPL_DEPTH_8U, 3 );	//	ϊ̉摜pIplImage

	CvPoint2D32f center = cvPoint2D32f( sourceImage->width / 2.0, sourceImage->height / 2.0);	//]S

	//	s𐶐
	CvMat *rotationMatrix = cvCreateMat( 2, 3, CV_32FC1 );	//	]s

	//	ϊs߂
	cv2DRotationMatrix( center, ANGLE, SCALE, rotationMatrix);

	//	摜̊gAkA]s
	cvWarpAffine( sourceImage, destinationImage, rotationMatrix, CV_INTER_LINEAR | CV_WARP_FILL_OUTLIERS, cvScalarAll( 0 ) );

	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDestination, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameDestination, destinationImage );

	//	L[͂҂
	cvWaitKey( 0 );

	//	摜ۑ
	cvSaveImage( "image/destination.bmp", destinationImage );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &destinationImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameDestination );

  return 0;
}

