//---------------------------------------------------------
// Tv      : 摜̍
// File Name : chromakey.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include	<stdio.h>
#include	<cv.h>
#include	<cxcore.h>
#include	<highgui.h>

#define TRACKBAR_MAX_VALUE	255	//	gbNo[̍ől
#define MIN_VALUE	0			//	臒l̏l
#define MAX_VALUE	255			//	臒l̏l

//	臒lۑ\
typedef struct border {
	int blue;	//	臒l
	int green;	//	΂臒l
	int red;	//	Ԃ臒l
} BORDER;

int main( int argc, char **argv ) {
	int key;	//	L[͗p̕ϐ
	BORDER lower = { MIN_VALUE, MIN_VALUE, MIN_VALUE };	//	臒l
	BORDER upper = { MAX_VALUE, MAX_VALUE, MAX_VALUE };	//	臒l

	char windowNameBackground[] = "Background";	//	wi\EBhE̖O
	char windowNameChromakey[] = "Chromakey"; 	//	ʂ\EBhE̖O
	char windowNameExtract[] = "Extract"; 	//	oꂽ̂\EBhE̖O
	char windowNameObject[]	 = "Object"; 	//	oꂽ̂\EBhE̖O

	char trackbarNameLowerBlue[] = "LowerBlue";
	char trackbarNameUpperBlue[] = "UpperBlue";
	char trackbarNameLowerGreen[] = "LowerGreen";
	char trackbarNameUpperGreen[] = "UpperGreen";
	char trackbarNameLowerRed[] = "LowerRed";
	char trackbarNameUpperRed[] = "UpperRed";

	//	摜ƍ镨̂̉摜ǂݍ
	IplImage *backgroundImage = cvLoadImage( "image/background.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );	//	wi摜pIplImage
	IplImage *objectImage = cvLoadImage( "image/object.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );			//	Ώۉ摜pIplImage
	
	if ( backgroundImage == NULL || objectImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	//	摜TCY𓾂
	CvSize sizeOfBackground	= cvGetSize( backgroundImage );
	CvSize sizeOfObject = cvGetSize( objectImage );

	if ( sizeOfBackground.height != sizeOfObject.height ||
			sizeOfBackground.width != sizeOfObject.width ) {
		//	摜̃TCYقȂꍇ
		printf( "摜̃TCYقȂ܂\n" );
		return -1;
	}

	//	摜𐶐
	IplImage *maskImage = cvCreateImage( sizeOfObject, IPL_DEPTH_8U, 1 );			//	}XNpIplImage
	IplImage *inverseMaskImage = cvCreateImage( sizeOfObject, IPL_DEPTH_8U, 1 );	//	}XN]pIplImage

	IplImage *extractedBackgroundImage = cvCreateImage( sizeOfObject, IPL_DEPTH_8U, 3 );	//	̂wi摜pIplImage
	IplImage *extractedObjectImage = cvCreateImage( sizeOfObject, IPL_DEPTH_8U, 3 );		//	̂oꂽ摜pIplImage
	IplImage *destinationImage = cvCreateImage( sizeOfObject, IPL_DEPTH_8U, 3 );			//	ʉ摜pIplImage

	//EBhE𐶐
	cvNamedWindow( windowNameBackground, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameObject, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameChromakey, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameExtract, CV_WINDOW_AUTOSIZE );

	//	摜\
	cvShowImage( windowNameBackground, backgroundImage );
	cvShowImage( windowNameObject, objectImage );
	
	//	gbNo[𐶐
	cvCreateTrackbar( trackbarNameLowerBlue, windowNameChromakey, &lower.blue, TRACKBAR_MAX_VALUE, NULL);
	cvCreateTrackbar( trackbarNameUpperBlue, windowNameChromakey, &upper.blue, TRACKBAR_MAX_VALUE, NULL);
	cvCreateTrackbar( trackbarNameLowerGreen, windowNameChromakey, &lower.green, TRACKBAR_MAX_VALUE, NULL);
	cvCreateTrackbar( trackbarNameUpperGreen, windowNameChromakey, &upper.green, TRACKBAR_MAX_VALUE, NULL);
	cvCreateTrackbar( trackbarNameLowerRed, windowNameChromakey, &lower.red, TRACKBAR_MAX_VALUE, NULL);
	cvCreateTrackbar( trackbarNameUpperRed, windowNameChromakey, &upper.red, TRACKBAR_MAX_VALUE, NULL);

	//	C[v
	//	oRGB͈̔͂pӁ@ʏB,G,ȐɊi[邱ƂɒӁ@
	//	͈͍͂ŏlȏőlɂȂ̂upper+1Ă
	while ( 1 ) {
		CvScalar lowerValue = cvScalar( lower.blue, lower.green, lower.red );
		CvScalar upperValue = cvScalar( upper.blue+1, upper.green+1, upper.red+1 );

		//	RGBe`lƂɔ͈͓̒lȊỎf}XNɐݒ肷
		cvInRangeS( objectImage, lowerValue, upperValue, maskImage );

		//	wi摜̂镨̉̕fl0ɂ
		cvSetZero( extractedBackgroundImage );
		cvCopy( backgroundImage, extractedBackgroundImage, maskImage );

		//	}XN摜01𔽓]
		cvNot( maskImage, inverseMaskImage );

		//	gbNo[̏𖞂̂oꂽ摜쐬 
		cvSetZero( extractedObjectImage );
		cvCopy( objectImage, extractedObjectImage, inverseMaskImage );

		//	wi摜ƍ̉摜̍
		cvAdd( extractedBackgroundImage, extractedObjectImage, destinationImage, NULL);

		//	摜\
		cvShowImage( windowNameExtract,	extractedObjectImage );
		cvShowImage( windowNameChromakey, destinationImage );
		
		//	L[͔
		key = cvWaitKey( 1 );
		if ( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		}
	}

	//	
	cvReleaseImage( &objectImage );
	cvReleaseImage( &extractedObjectImage );
	cvReleaseImage( &extractedBackgroundImage );
	cvReleaseImage( &maskImage );
	cvReleaseImage( &inverseMaskImage );
	cvReleaseImage( &destinationImage );
	//	EBhEj
	cvDestroyWindow( windowNameBackground );
	cvDestroyWindow( windowNameObject );
	cvDestroyWindow( windowNameChromakey );
	cvDestroyWindow( windowNameExtract );

	return 0;
}