//---------------------------------------------------------
// Tv      : 摜ZsAFɂ
// File Name : sepia.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define	DEFAULT_H	22	//	Hlul
#define	DEFAULT_S	90	//	Slul

int main( int argc, char **argv ){
	char windowNameSource[] = "Source";		//	摜\EBhE̖O
	char windowNameSepia[] = "Sepia"; 		//	ʂ\EBhE̖O

	//	摜ǂݍ	
	IplImage *sourceImage = cvLoadImage( "image/source.bmp", CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR );

	if ( sourceImage == NULL ) {
		//	摜Ȃꍇ
		printf( "摜܂\n" );
		return -1;
	}

	CvSize sizeOfImage = cvGetSize( sourceImage );

	//	摜𐶐
	IplImage *hsvImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 3 );			//	HSV摜pIplImage
	IplImage *hueImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 1);			//	F(H)pIplImage
	IplImage *saturationImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 1);	//	ʓx(S)pIplImage
	IplImage *valueImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 1);		//	x(V)pIplImage

	IplImage *mergeImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 3 );		//	}[WpIplImage
	IplImage *destinationImage = cvCreateImage( sizeOfImage, IPL_DEPTH_8U, 3 );	//	ʏo͗pIplImage

	CvScalar valueH = cvScalar( DEFAULT_H );
	CvScalar valueS = cvScalar( DEFAULT_S );

	//	EBhE𐶐
	cvNamedWindow( windowNameSource, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameSepia, CV_WINDOW_AUTOSIZE );

	//	BGRHSVɕϊ
	cvCvtColor( sourceImage, hsvImage, CV_BGR2HSV );

	//	HSV摜HASAV摜ɕ
	cvSplit( hsvImage, hueImage, saturationImage, valueImage, NULL ); 

	//	HS̒lύX
	cvSet( hueImage, valueH, NULL );
	cvSet( saturationImage, valueS, NULL );

	//	3`l
	cvMerge( hueImage, saturationImage, valueImage, NULL, mergeImage );

	//	HSVBGRɕϊ
	cvCvtColor( mergeImage, destinationImage, CV_HSV2BGR );

	//	摜\
	cvShowImage( windowNameSource, sourceImage );
	cvShowImage( windowNameSepia, destinationImage );

	//	L[͂҂
	cvWaitKey( 0 );

	//	
	cvReleaseImage( &sourceImage );
	cvReleaseImage( &hsvImage );
	cvReleaseImage( &hueImage );
	cvReleaseImage( &saturationImage );
	cvReleaseImage( &valueImage );
	cvReleaseImage( &mergeImage );
	cvReleaseImage( &destinationImage );
	//	EBhEj
	cvDestroyWindow( windowNameSource );
	cvDestroyWindow( windowNameSepia );

	return 0;
}
