//---------------------------------------------------------
// Tv      : ̈~ň͂
// File Name : tutorial_04.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define WIDTH	640	//	Lv`摜̉
#define HEIGHT	480	//	Lv`摜̏c

#define THRESH_BOTTOM	10		//	Fl̉臒l
#define THRESH_TOP	55			//	Fl̏臒l
#define THRESHOLD_MAX_VALUE	255	//	2l̍ۂɎgpől

#define CIRCLE_RADIUS	20	//	~̔a
#define LINE_THICKNESS	2	//	̑
#define LINE_TYPE	8		//	̎

int main( int argc, char **argv ){ 
	int key;							//	L[͗p̕ϐ
	CvCapture *capture = NULL;			//	JLv`p̍\
	IplImage *frameImage;				//	Lv`摜pIplImage

	//	摜𐶐
	IplImage *backgroundImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	wi摜pIplImage
	IplImage *grayImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );			//	O[XP[摜pIplImage
	IplImage *differenceImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	摜pIplImage
	
	IplImage *hsvImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 3 );			//	HSV摜pIplImage
	IplImage *hueImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );			//	F(H)pIplImage
	IplImage *saturationImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	ʓx(S)pIplImage
	IplImage *valueImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );			//	x(V)pIplImage
	IplImage *thresholdImage1 = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	FlTHRES_BOTTOM傫̈pIplImage
	IplImage *thresholdImage2 = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	FlTHRES_TOPȉ̗̈pIplImage
	IplImage *thresholdImage3 = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	thresholdImage1thresholdImage2ANDZʗpIplImage
	IplImage *faceImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );			//	̈̒oʗpIplImage
	
	char windowNameCapture[] = "Capture"; 		//	Lv`摜\EBhE̖O
	char windowNameFace[] = "Face";				//	̈\EBhE̖O
	
	CvMoments moment;
	double m_00;
	double m_10;
	double m_01;
	int gravityX;
	int gravityY;
    
	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ) {
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}

	//	EBhE𐶐
	cvNamedWindow( windowNameCapture, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameFace, CV_WINDOW_AUTOSIZE );
  	
  	//	wiݒ肷邽߂ɃJ摜擾
	frameImage = cvQueryFrame( capture );
	//	frameImageO[XP[Awi摜Ƃ
	cvCvtColor( frameImage, backgroundImage, CV_BGR2GRAY );
	
	//	C[v
	while( 1 ) {
		//	capture͉̓摜1t[frameImageɊi[
		frameImage = cvQueryFrame( capture );
		//	frameImageO[XP[̂AgrayImageɊi[
		cvCvtColor( frameImage, grayImage, CV_BGR2GRAY );
		//	grayImageƔwi摜Ƃ̍Ƃ
		cvAbsDiff( grayImage, backgroundImage, differenceImage );
		
		//	frameImageBGRHSVɕϊ
		cvCvtColor( frameImage, hsvImage, CV_BGR2HSV );
		//	HSV摜HASAV摜ɕ
		cvSplit( hsvImage, hueImage, saturationImage, valueImage, NULL );
		//	FFɋ߂𒊏oÂ̕ݏo͂
		cvThreshold( hueImage, thresholdImage1, THRESH_BOTTOM, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY );
		cvThreshold( hueImage, thresholdImage2, THRESH_TOP, THRESHOLD_MAX_VALUE, CV_THRESH_BINARY_INV );
		cvAnd( thresholdImage1, thresholdImage2, thresholdImage3, NULL );
		
		//	wi摜ƔF̈ƂANDƂ
		cvAnd( differenceImage, thresholdImage3, faceImage, NULL );
		
		//	F̈̏dSZo
		cvMoments( faceImage, &moment, 0 );
		m_00 = cvGetSpatialMoment( &moment, 0, 0 );
		m_10 = cvGetSpatialMoment( &moment, 1, 0 );
		m_01 = cvGetSpatialMoment( &moment, 0, 1 );
		gravityX = m_10 / m_00;
		gravityY = m_01 / m_00;
		
		//	摜ɉ~`悷
		cvCircle( frameImage, cvPoint( gravityX, gravityY ), CIRCLE_RADIUS,
			 CV_RGB( 255, 0, 0 ), LINE_THICKNESS, LINE_TYPE, 0 );

		if ( faceImage->origin == 0 ) {
			//@オ_̏ꍇ
			cvFlip( faceImage, faceImage, 0 );
		}

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		cvShowImage( windowNameFace, faceImage );
		
		//	L[͔
		key = cvWaitKey( 1 );
		if( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		} else if( key == 'b' ) {
			//	'b'L[ꂽA̎_ł̉摜wi摜Ƃ
		   frameImage = cvQueryFrame( capture );
		    cvCvtColor( frameImage, backgroundImage, CV_BGR2GRAY );
		} else if(key == 'c') {
			//	'c'L[ꂽ摜ۑ
			cvSaveImage( "image/frame.bmp", frameImage );
			cvSaveImage( "image/face.bmp", faceImage );
		}
	}
	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &backgroundImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &differenceImage );
	cvReleaseImage( &hsvImage );
	cvReleaseImage( &hueImage );
	cvReleaseImage( &saturationImage );
	cvReleaseImage( &valueImage );
	cvReleaseImage( &thresholdImage1 );
	cvReleaseImage( &thresholdImage2 );
	cvReleaseImage( &thresholdImage3 );
	cvReleaseImage( &faceImage );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameFace );
	
	return 0;
}
