//---------------------------------------------------------
// Tv      : wiƂ
// File Name : tutorial_02.cpp
// Library   : OpenCV for MS-Windows 1.0
//---------------------------------------------------------

#include <stdio.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>

#define WIDTH	640	//	Lv`摜̉
#define HEIGHT	480	//	Lv`摜̏c

int main( int argc, char **argv ) { 
	int key;							//	L[͗p̕ϐ
	CvCapture *capture = NULL;			//	JLv`p̍\
	IplImage *frameImage;				//	Lv`摜pIplImage
	
	//	摜𐶐
	IplImage *backgroundImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	wi摜pIplImage
	IplImage *grayImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );		//	O[XP[摜pIplImage
	IplImage *differenceImage = cvCreateImage( cvSize(WIDTH, HEIGHT), IPL_DEPTH_8U, 1 );	//	摜pIplImage
	
	char windowNameCapture[] = "Capture"; 			//	Lv`摜\EBhE̖O
	char windowNameDifference[] = "Difference";		//	wiʂ\EBhE̖O
    
	//	J
	if ( ( capture = cvCreateCameraCapture( -1 ) ) == NULL ) {
		//	JȂꍇ
		printf( "J܂\n" );
		return -1;
	}

	//	EBhE𐶐
	cvNamedWindow( windowNameCapture, CV_WINDOW_AUTOSIZE );
	cvNamedWindow( windowNameDifference, CV_WINDOW_AUTOSIZE );
    
	//	wiݒ肷邽߂ɃJ摜擾
	frameImage = cvQueryFrame( capture );
	//	frameImageO[XP[Awi摜Ƃ
	cvCvtColor( frameImage, backgroundImage, CV_BGR2GRAY );
    
	//	C[v
	while ( 1 ) {
		//	capture͉̓摜1t[frameImageɊi[
		frameImage = cvQueryFrame( capture );
		//	frameImageO[XP[̂AgrayImageɊi[
		cvCvtColor( frameImage, grayImage, CV_BGR2GRAY );
		//	grayImageƔwi摜Ƃ̍Ƃ
		cvAbsDiff( grayImage, backgroundImage, differenceImage );

		if ( differenceImage->origin == 0 ) {
			//@オ_̏ꍇ
			cvFlip( differenceImage, differenceImage, 0 );
		}

		//	摜\
		cvShowImage( windowNameCapture, frameImage );
		cvShowImage( windowNameDifference, differenceImage );

		//	L[͔
		key = cvWaitKey( 1 );
		if ( key == 'q' ) {
			//	'q'L[ꂽ烋[v𔲂
			break;
		} else if ( key == 'b' ) {
			//	'b'L[ꂽA̎_ł̃Lv`摜wi摜Ƃ
		    frameImage = cvQueryFrame( capture );
		    cvCvtColor( frameImage, backgroundImage, CV_BGR2GRAY );
		}
	}

	//	Lv`
	cvReleaseCapture( &capture );
	//	
	cvReleaseImage( &backgroundImage );
	cvReleaseImage( &grayImage );
	cvReleaseImage( &differenceImage );
	//	EBhEj
	cvDestroyWindow( windowNameCapture );
	cvDestroyWindow( windowNameDifference );

	return 0;
}