import uvicorn
from a2a.server.apps import A2AStarletteApplication
from a2a.server.request_handlers import DefaultRequestHandler
from a2a.server.tasks import InMemoryTaskStore
from a2a.types import (
    AgentCapabilities,
    AgentCard,
    AgentSkill,
)
from agent_executor import TravelPlannerAgentExecutor

# メイン
if __name__ == '__main__':
    # エージェントカードの準備
    skill = AgentSkill(
        id='travel_planner',
        name='travel planner agent',
        description='travel planner',
        tags=['travel planner'],
        examples=['hello', 'nice to meet you!'],
    )
    agent_card = AgentCard(
        name='travel planner Agent',
        description='travel planner',
        url='http://localhost:10001/',
        version='1.0.0',
        defaultInputModes=['text'],
        defaultOutputModes=['text'],
        capabilities=AgentCapabilities(streaming=True),
        skills=[skill],
    )

    # リクエストハンドラの作成
    request_handler = DefaultRequestHandler(
        agent_executor=TravelPlannerAgentExecutor(), # エージェント実行ロジック
        task_store=InMemoryTaskStore(), # メモリ内タスクストア
    )

    # A2Aサーバの作成
    server = A2AStarletteApplication(
        agent_card=agent_card, # エージェントカード
        http_handler=request_handler, # リクエストハンドラ
    )

    # A2Aサーバの実行
    uvicorn.run(server.build(), host='0.0.0.0', port=10001)