from a2a.server.agent_execution import AgentExecutor, RequestContext
from a2a.server.events import EventQueue
from a2a.utils import new_agent_text_message

# コアエージェントの作成
class HelloWorldAgent:
    # 呼び出し
    async def invoke(self) -> str:
        return 'Hello World!'
    
# AgentExecutorの作成
class HelloWorldAgentExecutor(AgentExecutor):

    # 初期化
    def __init__(self):
        # コアエージェントの準備
        self.agent = HelloWorldAgent()

    # 実行
    async def execute(
        self,
        context: RequestContext,  # リクエストコンテキスト
        event_queue: EventQueue,  # イベントキュー
    ) -> None:
        result = await self.agent.invoke()  # コアエージェントの呼び出し
        await event_queue.enqueue_event(
            new_agent_text_message(result)  # 結果を返す
        )

    # キャンセル
    async def cancel(
        self, 
        context: RequestContext,  # リクエストコンテキスト
        event_queue: EventQueue,  # イベントキュー
    ) -> None:
        raise Exception('キャンセルは未サポートです')