import uvicorn
from a2a.server.apps import A2AStarletteApplication
from a2a.server.request_handlers import DefaultRequestHandler
from a2a.server.tasks import InMemoryTaskStore
from a2a.types import (
    AgentCapabilities,
    AgentCard,
    AgentSkill,
)
from agent_executor import (
    HelloWorldAgentExecutor,  # type: ignore[import-untyped]
)

# メイン
if __name__ == '__main__':
    # エージェントカードの準備
    skill = AgentSkill(
        id='hello_world',                         # スキルの一意な識別子
        name='Returns hello world',               # スキル名
        description='just returns hello world',   # スキルの説明
        tags=['hello world'],                     # タグ
        examples=['hi', 'hello world'],           # サンプル入力例
    )
    public_agent_card = AgentCard(
        name='Hello World Agent',                 # エージェントの表示名
        description='Just a hello world agent',   # 説明文
        url='http://localhost:9999/',             # サービスURL
        version='1.0.0',                          # バージョン
        defaultInputModes=['text'],               # デフォルト入力モード
        defaultOutputModes=['text'],              # デフォルト出力モード
        capabilities=AgentCapabilities(streaming=True),  # ストリーミング対応
        skills=[skill],                           # 公開カードに含めるスキル（基本スキルのみ）
        supportsAuthenticatedExtendedCard=False,  # 認証後に拡張カードをサポート
    )

    # リクエストハンドラの作成
    request_handler = DefaultRequestHandler(
        agent_executor=HelloWorldAgentExecutor(), # エージェント実行ロジック
        task_store=InMemoryTaskStore(), # メモリ内タスクストア
    )

    # A2Aサーバの作成
    server = A2AStarletteApplication(
        agent_card=public_agent_card, # エージェントカード
        http_handler=request_handler, # リクエストハンドラ
    )

    # A2Aサーバの実行
    uvicorn.run(server.build(), host='0.0.0.0', port=9999)