from mcp.server.fastmcp import FastMCP, Context
from mcp.server.session import ServerSession
from pathlib import Path
from urllib.parse import urlparse, unquote


# MCPサーバの準備
mcp = FastMCP(name="root_server")


@mcp.tool()
async def list_allowed_areas(ctx: Context[ServerSession, None]) -> list[dict]:
    """ クライアントから渡されてるルート一覧の確認 """
    result = await ctx.session.list_roots()
    return [r.model_dump() for r in result.roots]


@mcp.tool()
async def get_sales_ranking(ctx: Context[ServerSession, None]) -> str:
    """営業ランキングの取得"""

    # ルート一覧を取得
    result = await ctx.session.list_roots()
    roots = result.roots
    if not roots:
        raise RuntimeError("クライアントからルートが提供されていません")

    # ルートパスの取得
    uri_str = str(roots[0].uri)
    parsed = urlparse(uri_str)
    root_path = Path(unquote(parsed.path))

    # ファイルの読み込み
    target = root_path / "SalesRanking.txt"
    if not target.exists():
        raise FileNotFoundError(f"見つかりません: {target}")
    return target.read_text(encoding="utf-8")


if __name__ == "__main__":
    """メイン"""
    mcp.run(transport='stdio')