from mcp.server.fastmcp import FastMCP
from pathlib import Path


# MCPサーバの準備
mcp = FastMCP(name="resource_server")


@mcp.resource("resource://SalesRanking.txt")
def read_document() -> str:
    """テキストリソースの提供"""
    p = Path("/Users/npaka/Documents/book/MCP/sample/4_mcp_sdk/2_resource/resource_server/SalesRanking.txt")
    return p.read_text(encoding="utf-8")


@mcp.resource("image://cat.png", mime_type="image/png")
def read_image() -> bytes:
    """画像リソースの提供"""
    p = Path("/Users/npaka/Documents/book/MCP/sample/4_mcp_sdk/2_resource/resource_server/cat.png")
    return p.read_bytes()


@mcp.resource("data://config")
def get_config() -> dict:
    """辞書リソースの提供"""
    return {
        "theme": "dark",
        "version": "1.2.0",
        "features": ["tools", "resources"],
    }


if __name__ == "__main__":
    """メイン"""
    mcp.run(transport='stdio')