from mcp.server.fastmcp import FastMCP
from mcp.types import PromptMessage, TextContent


# MCPサーバの準備
mcp = FastMCP(name="prompt_server")


@mcp.prompt()
def ask_about_topic(topic: str) -> str:
    """文字列プロンプトの提供"""
    return f"'{topic}'を説明して"


@mcp.prompt()
def generate_code_request(language: str, task_description: str) -> PromptMessage:
    """メッセージプロンプトの提供"""
    content = f"言語'{language}'で次のタスクを実行するコードを生成して: {task_description}"
    return PromptMessage(role="user", content=TextContent(type="text", text=content))


if __name__ == "__main__":
    """メイン"""
    mcp.run(transport='stdio')