from agents import Agent, Runner
from agents.mcp.server import MCPServerStdio

async def main():
    # MCPサーバの準備
    async with MCPServerStdio(
        params={
            "command": "npx", 
            "args": ["-y", "@automatalabs/mcp-server-playwright"]
        }
    ) as mcp_server:
        # エージェントの準備
        agent = Agent(
            name="mcp_agent",
            instructions="あなたは役に立つエージェントです。",
            model="gpt-5",
            mcp_servers=[mcp_server]
        )

        # エージェントの実行
        run_result = await Runner.run(
            agent,
            "playwrightを使ってブラウザで「https://github.com/microsoft/playwright」を開いて",
        )
        print(run_result.final_output)

if __name__ == "__main__":
    asyncio.run(main())