import asyncio
from google.adk.agents import Agent
from google.adk.sessions import InMemorySessionService
from google.adk.runners import Runner
from google.genai.types import Content, Part
from google.adk.tools.mcp_tool.mcp_toolset import MCPToolset, StdioServerParameters

async def main():
    # エージェントの準備
    agent = Agent(
        name="mcp_agent",
        description="役に立つエージェント",
        instruction="あなたは役に立つエージェントです",
        model="gemini-2.5-flash",
        tools=[
            MCPToolset(
                connection_params=StdioServerParameters(
                    command="npx",
                    args=[
                        "-y",
                        "@automatalabs/mcp-server-playwright"
                    ],
                ),
            )
        ],

    )

    # ランナーの準備
    runner = Runner(
        app_name=agent.name,
        agent=agent,
        session_service=InMemorySessionService(),
    )

    # セッションの準備
    session_id, user_id = "sess1", "user1"
    await runner.session_service.create_session(
        app_name=agent.name,
        session_id=session_id,
        user_id=user_id,
    )

    # エージェントの実行
    async for chunk in runner.run_async(
        new_message=Content(role="user", parts=[Part(text="playwrightを使ってブラウザで「https://github.com/microsoft/playwright」を開いて")]), 
        session_id=session_id, 
        user_id=user_id
    ):
        print(chunk.content.parts[0].text, end="", flush=True)
    print()

if __name__ == "__main__":
    asyncio.run(main())