using UnityEngine;

// 指定した方向を向き、時間が経ったら自分を削除する
public class ParticleLookAtTarget : MonoBehaviour
{
    //-------------------------------------
    // 向く対象のオブジェクト名
    public string targetName = "";
    // 何秒後に削除するか
    public float limitSec = 5f;
    //-------------------------------------

    void Start()
    {
        // ターゲットを名前で探す
        GameObject target = GameObject.Find(targetName);
        if (target != null)
        {
            // ターゲットの方向を計算して回転を設定
            Vector3 direction = (target.transform.position - transform.position).normalized;
            transform.rotation = Quaternion.LookRotation(direction);
        }
        // 指定秒数後に自分を削除
        Destroy(this.gameObject, limitSec);
    }
}
