using UnityEngine;
using UnityEngine.InputSystem;

// マウスの左クリックが押されたら、カウントを増やす
public class OnMouseClickCount : MonoBehaviour
{
    //-------------------------------------
    // どのカウンターを増やすか
    public CounterType kind = CounterType.Keys;
    // 増やす数値
    public int addValue = 1;
    //-------------------------------------

    void Update() 
    {
        // マウスが存在していて、左クリックが押されたら
        var mouse = Mouse.current;
        if (mouse != null && mouse.leftButton.wasPressedThisFrame)
        {
            // GameCounter の共有データにアクセスして、指定カウンターを増やす
            GameCounter.counters[kind] += addValue;
        }
    }
}
