﻿using UnityEngine;
using UnityEngine.SceneManagement;    // シーン切り替えに必要

// カウントが指定の値になったら、シーンを切り換える
public class OnCountCompleteSwitchScene : MonoBehaviour 
{
    //-------------------------------------
    // どのカウンターを見るか
    public CounterType kind = CounterType.Keys;
    // この値になったら切り換える
    public int lastCount = 3;
    // 切り換えるシーン名
    public string sceneName = "";
    //-------------------------------------

    void Update()
    {
        // カウンターが最終値になったらシーンを切り換える
        if (GameCounter.counters[kind] == lastCount) 
        {
            SceneManager.LoadScene(sceneName);
        }
    }
}
