﻿using UnityEngine;

// カウントが指定の値になったら、ゲームを停止する
public class OnCountCompleteStopGame : MonoBehaviour 
{
    //-------------------------------------
    // どのカウンターを見るか
    public CounterType kind = CounterType.Keys;
    // この値になったら停止する
    public int lastCount = 3;
    //-------------------------------------

    void Start()
    {
        // ゲーム開始時は時間を動かしておく
        Time.timeScale = 1;
    }

    void Update() 
    {
        // カウンターが最終値になったら時間を止める
        if (GameCounter.counters[kind] == lastCount) 
        {
            Time.timeScale = 0;
        }
    }
}
