﻿using UnityEngine;

// カウントが指定の値になったら、オブジェクトを表示する
public class OnCountCompleteShow : MonoBehaviour 
{
    //-------------------------------------
    // どのカウンターを見るか
    public CounterType kind = CounterType.Keys;
    // この値になったら表示する
    public int lastCount = 3;
    // 表示するオブジェクト
    public GameObject showObject;
    //-------------------------------------

    void Start()
    {
        // 最初は非表示にしておく
        showObject.SetActive(false);
    }

    void Update()
    {
        // カウンターが最終値になったら表示する
        if (GameCounter.counters[kind] == lastCount) 
        {
            showObject.SetActive(true);
        }
    }
}
