﻿using UnityEngine;

// カウントが指定の値になったら、オブジェクトを非表示にする
public class OnCountCompleteHide : MonoBehaviour 
{
    //-------------------------------------
    // どのカウンターを見るか
    public CounterType kind = CounterType.Keys;
    // この値になったら非表示にする
    public int lastCount = 3;
    // 非表示にするオブジェクト
    public GameObject hideObject;
    //-------------------------------------

    void Update()
    {
        // カウンターが最終値になったら非表示にする
        if (GameCounter.counters[kind] == lastCount) 
        {
            hideObject.SetActive(false);
        }
    }
}
