﻿using UnityEngine;

// 衝突したら、カウントを増やす
public class OnCollisionCount : MonoBehaviour 
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // どの種類のカウンターを増やすか
    public CounterType kind = CounterType.Keys;
    // 増やす数値
    public int addValue = 1;
    //-------------------------------------

    void OnCollisionEnter(Collision collision) 
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            // GameCounter の共有データにアクセスして、指定カウンターを増やす
            GameCounter.counters[kind] += addValue;
        }
    }
}
