using System.Collections.Generic;
using UnityEngine;
using TMPro;

// カウンター本体（数値を管理して画面に表示する）
public class GameCounter : MonoBehaviour
{
    //-------------------------------------
    // このカウンターの種類（Keys, Hearts, Score など）
    public CounterType kind = CounterType.Keys;
    // 開始時の数値
    public int startCount = 0;
    // 数値を表示するテキスト（TextMeshPro）
    public TextMeshProUGUI displayText;
    //-------------------------------------

    // 全種類のカウンターをまとめて管理する辞書
    // static にしているので、どのオブジェクトからでも共有してアクセスできる
    public static Dictionary<CounterType, int> counters = new Dictionary<CounterType, int>();

    void Start()
    {
        // このカウンターの初期値を設定
        counters[kind] = startCount;
    }

    void Update()
    {
        // テキストが設定されていれば、現在の値を表示
        if (displayText)
            displayText.text = counters[kind].ToString();
    }
}

// カウンターの種類
public enum CounterType
{
    Keys, Hearts, Miss, Score, Gold, ItemA, ItemB, ItemC
}
