﻿using UnityEngine;

// 一定間隔で、ランダムな位置にプレハブを作る
public class SometimeRandomCreatePrefab : MonoBehaviour
{
    //-------------------------------------
    // 作るプレハブ
    public GameObject newPrefab;
    // 作成する間隔（秒）
    public float intervalSec = 1;
    //-------------------------------------

    void Start()
    {
        // このオブジェクトに Collider が付いていたら削除（邪魔にならないようにする）
        Collider col = this.gameObject.GetComponent<Collider>();
        if (col) Destroy(col);
        // intervalSec秒 ごとに CreatePrefab を繰り返し呼び出す
        InvokeRepeating("CreatePrefab", intervalSec, intervalSec);
    }

    void CreatePrefab()
    {
        // このオブジェクトの範囲（Renderer の大きさ）を調べる
        var bounds = GetComponent<Renderer>().bounds;
        // 範囲内のランダムな位置を計算
        Vector3 randomPos = new Vector3(
            Random.Range(bounds.min.x, bounds.max.x),
            Random.Range(bounds.min.y, bounds.max.y),
            Random.Range(bounds.min.z, bounds.max.z)
        );

        // プレハブから新しいオブジェクトを作成
        GameObject newGameObject = Instantiate(newPrefab, randomPos, Quaternion.identity);
    }
}
