using UnityEngine;

// 衝突したら、自分や相手を削除する
public class OnCollisionDestroy : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // どちらを削除するか（自分／相手／両方）
    public Options destroyOption;
    //-------------------------------------

    void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            if (destroyOption == Options.Me)
            {
                // 自分を削除
                Destroy(gameObject);
            }
            else if (destroyOption == Options.You)
            {
                // 相手を削除
                Destroy(collision.gameObject);
            }
            else if (destroyOption == Options.YouAndMe) 
            { 
                // 両方削除
                Destroy(collision.gameObject);
                Destroy(gameObject);
            }
        }
    }
}

// 削除対象の種類
public enum Options
{
    Me,        // 自分を削除
    You,       // 相手を削除
    YouAndMe   // 両方削除
}
