﻿using UnityEngine;

// 衝突したら、プレハブを作る
public class OnCollisionCreatePrefab : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // 作るプレハブ
    public GameObject newPrefab;
    // 生成する位置のずれ（オフセット）
    public Vector3 offset;
    //-------------------------------------
    
    void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            // 衝突した位置に、オフセットを加えてプレハブを作成
            Vector3 pos = collision.contacts[0].point + offset;
            GameObject newGameObject = Instantiate(newPrefab, pos, Quaternion.identity);
        }
    }
}
