﻿using UnityEngine;
using UnityEngine.InputSystem;

[RequireComponent(typeof(PlayerInput))]   // なければ自動で追加

// 攻撃キーを押したら、プレハブを投げる
public class OnAttackThrow : MonoBehaviour
{
    //-------------------------------------
    // 投げるプレハブ
    public GameObject newPrefab;
    // 投げる力（X=左右、Y=上下、Z=前後）
    public Vector3 throwForce = new Vector3(0f, 3f, 4f);
    // 生成位置のずれ（プレイヤーの前方など）
    public Vector3 offset = new Vector3(0f, 0.5f, 0.5f);
    //-------------------------------------

    void OnAttack()
    {
        // プレイヤー位置＋向きに応じたオフセットを加えて生成位置を決める
        Vector3 spawnPos = transform.position + transform.rotation * offset;

        // プレハブから新しいオブジェクトを作成
        GameObject newGameObject = Instantiate(newPrefab);
        newGameObject.transform.position = spawnPos;

        // Rigidbody を取得して、投げる力を加える
        Rigidbody rbody = newGameObject.GetComponent<Rigidbody>();
        Vector3 force = transform.rotation * throwForce;
        rbody.AddForce(force, ForceMode.Impulse);
    }
}
