using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

// ゲームを開始・停止・リロードするシンプルなマネージャ
public class SimpleGameManager : MonoBehaviour
{
    //-------------------------------------
    // スタートボタン（ゲーム開始時に押すUIボタン）
    public Button startButton;
    // タイトル画像（停止時に表示するUI画像）
    public GameObject titleImage;
    //-------------------------------------
    public static bool reloadStart = false;

    void Start()
    {
        // スタートボタンがあればクリック時の動作を登録
        if (startButton != null)
        {
            startButton.onClick.RemoveAllListeners();
            startButton.onClick.AddListener(DoStartGame);
        }
        if (!reloadStart)
        {
            DoStopGame();    // 通常は、タイトル（停止）から開始
        }
        else
        {
            reloadStart = false;
            DoStartGame();   // リロード直後はタイトルを表示せずスタート
        }
    }

    // ゲームを開始（UIを非表示にしてプレイ開始）
    public void DoStartGame()
    {
        if (startButton != null) startButton.gameObject.SetActive(false);
        if (titleImage != null) titleImage.SetActive(false);

        Time.timeScale = 1f; // 時間を進めてゲーム開始
    }

    // ゲームを停止（UIを表示してプレイ停止）
    public void DoStopGame()
    {
        if (startButton != null) startButton.gameObject.SetActive(true);
        if (titleImage != null) titleImage.SetActive(true);

        Time.timeScale = 0f; // 時間を止めてゲーム停止
    }

    // シーンをリロードしてゲームを再スタート
    public void DoReloadAndStart()
    {
        reloadStart = true;  // リロード後に自動スタートする合図
        SceneManager.LoadScene(SceneManager.GetActiveScene().name);
    }
}
