﻿using UnityEngine;
using UnityEngine.SceneManagement;

// 衝突したら、シーンを切り換える
public class OnCollisionSwitchScene : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // シーン名（ここに名前を入れると、そのシーンに切り替える）
    public string sceneName = "";
    //-------------------------------------

    void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            // シーン名が指定されている場合、そのシーンへ切り替える
            if (sceneName != "")  
            {
                SceneManager.LoadScene(sceneName);
            }
            else
            {
                // シーン名が指定されていない場合 → ビルド設定の次のシーンへ
                int nextIndex = SceneManager.GetActiveScene().buildIndex + 1;
                if (nextIndex < SceneManager.sceneCountInBuildSettings)
                {
                    SceneManager.LoadScene(nextIndex);
                }
                else
                {
                    // 最後のシーンだった場合 → 最初のシーンへ戻る
                    SceneManager.LoadScene(0);
                }
            }
        }
    }
}
