using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

// ボタンを押したら、シーンを切り換える
public class OnButtonSwitchScene : MonoBehaviour
{
    //-------------------------------------
    // シーン名（ここに入力したシーンへ切り替える）
    public string sceneName = "";
    //-------------------------------------

    private void Start()
    {
        // アタッチされている Button コンポーネントを取得
        Button button = GetComponent<Button>();
        // ボタンが存在すれば、クリック時に OnButtonClick を呼ぶように設定
        if (button != null)
        {
            button.onClick.AddListener(OnButtonClick);
        }
    }

    private void OnButtonClick()
    {
        // SceneManager を使って指定したシーンへ切り替える
        SceneManager.LoadScene(sceneName);
    }
}
