﻿using UnityEngine;

// 衝突したら、ゲームを停止する
public class OnCollisionStopGame : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // ゲームマネージャ（指定されていれば、停止処理を任せる）
    public SimpleGameManager gm;
    //-------------------------------------

    private void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            if (gm != null)
            {
                // GameManager を使って停止処理を行う
                gm.DoStopGame();
            }
            else
            {
                // GameManager が無ければ、時間を止めてシンプルに停止
                Time.timeScale = 0f;
            }
        }
    }
}
