﻿using UnityEngine;

// 衝突したら、オブジェクトを表示する
public class OnCollisionShow : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // 表示するオブジェクト
    public GameObject showObject;
    //-------------------------------------

    void Start()
    {
        // 最初は非表示にしておく
        showObject.SetActive(false);
    }

    private void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName) 
        {
            // 指定したオブジェクトを表示する
            showObject.SetActive(true);
        }
    }
}
