﻿using UnityEngine;

// 衝突したら、オブジェクトを非表示にする
public class OnCollisionHide : MonoBehaviour
{
    //-------------------------------------
    // 目標オブジェクト（この相手に衝突したら反応）
    public GameObject targetObject;
    // タグ名（このタグを持つ相手に衝突したら反応）
    public string tagName = "";
    // 非表示にするオブジェクト
    public GameObject hideObject;
    //-------------------------------------

    private void OnCollisionEnter(Collision collision)
    {
        // 衝突した相手を取得
        var other = collision.gameObject;
        // 相手が「目標オブジェクト」か「指定タグ」を持っていれば
        if (other == targetObject || other.tag == tagName)
        {
            // 指定したオブジェクトを非表示にする
            hideObject.SetActive(false);
        }
    }
}
