﻿using UnityEngine;

[RequireComponent(typeof(Rigidbody))]   // なければ自動で追加
[RequireComponent(typeof(BoxCollider))] // なければ自動で追加

// ずっと、追いかける
public class ForeverChase : MonoBehaviour 
{
    //-------------------------------------
    // 目標オブジェクト（この相手を追いかける）
    public GameObject targetObject;
    // 目標オブジェクト名（名前で探して追いかける場合に使う）
    public string targetName = "";
    // 移動スピード
    public float moveSpeed = 3;
    // 壁をすり抜けるかどうか（オンなら壁を無視して進む）
    public bool ghostMode = false;
    // 進行方向に向きを合わせるか（オンで正面を進む向きにする）
    public bool faceForward = false;
    //-------------------------------------
    private Rigidbody rbody;

    void Start()
    {
        // Rigidbody を取得して設定する
        rbody = GetComponent<Rigidbody>();

        if (ghostMode)
        {
            // Rigidbody を取得して、物理的な力の影響を受けない設定にして
            // 壁を無視して進む
            rbody.isKinematic = true;
        }
        else
        {
            // 物理演算を有効にして、回転は固定する
            rbody.isKinematic = false;
            rbody.constraints = RigidbodyConstraints.FreezeRotation;
        }

        // targetObject が未指定なら、名前から探して設定
        if (targetObject == null && targetName != "")
        {
            targetObject = GameObject.Find(targetName);
        }
    }

    void FixedUpdate()
    {
        // 目標オブジェクトの方向を計算
        Vector3 dir = (targetObject.transform.position - transform.position).normalized;
        // 進む量（方向 × スピード）
        Vector3 move = dir * moveSpeed;

        if (ghostMode)
        {
            // Transform を直接動かして進む（壁を無視して進む）
            transform.position += move * Time.fixedDeltaTime;
        }
        else
        {
            // Rigidbody の速度を使って移動（物理的な衝突も有効）
            rbody.linearVelocity = new Vector3(move.x, rbody.linearVelocity.y, move.z);
        }

        // 進行方向に向きを合わせる
        int dirSign = faceForward ? 1 : -1;
        transform.rotation = Quaternion.LookRotation(dir * dirSign);
    }
}
